package com.datarobot.model;

import com.datarobot.impl.ClientException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Internal
 */
@JsonIgnoreProperties("links")
public class DatasetImportResponse extends ReturnsLocation implements ILocationResponse {
    // support different ID's formates on different endpoints
    private Pattern currentIdPattern = Pattern.compile("dataset|status/([a-f\\d-]{24,36})/$");
    
    @JsonProperty("statusId")
    private String statusId;
    
    @JsonProperty("datasetId")
    private String datasetId;
    
    private int statusCode;
    
    public String getDatasetId() {
    	return this.datasetId;
    }
    
    public void setDatasetId(String datasetId) {
    	this.datasetId = datasetId;
    }
    
    @Override
    public String getObjectId() {
    	return this.getDatasetId();
    }
    
    @Override
    public void setObjectId(String objectId) {
    	this.datasetId = objectId;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public int getStatusCode() {
        return statusCode;
    }

    @Override
    public String getStatusId() {
        return this.statusId;
    }
    
    // Ugly implementation right now - will refactor this interaction between DatasetImportResponse + ReturnsLocation in followup
    @Override
    public void setStatusId() {

    }

    @Override
    void parseIdFromUrl(String location) throws ClientException {
        Matcher matchId = currentIdPattern .matcher(location);
        if (!matchId.find()) {
            throw new ClientException("Invalid id in redirect header.");
        }
//        Used this method before to get statusId from location header - no longer necessary + will remove once ILocationResponse is refactored out completely. 
//        this.statusId = matchId.group(1);
    }
}
