package com.datarobot.model;

import java.io.InputStream;


/**
 * Internal
 * 
 * A IDatasetSource that is uploaded from an underlying InputStream (e.g. FileInputStream).
 */
public class DatasetStreamSource implements IDatasetSource {
    private InputStream input;
    private String name;
    private String contentType;

    /**
     *
     * @param name The name of the stream (e.g. File Name)
     * @param input The input stream that will be used for learning.
     */
    public DatasetStreamSource(String name, InputStream input)
    {
        this.input = input;
        this.name = name;
        this.contentType = "text/csv"; // default
    }

    /**
     * @return The InputStream that will be used for learning.
     */
    public InputStream getStream() {
        return input;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getName() {
        return name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getContentType() {
        return contentType;
    }
}
