package com.datarobot.model;

import com.fasterxml.jackson.annotation.*;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import static com.datarobot.impl.ApiConnection.JSON_TYPE;

/**
 * Internal
 * 
 * A IDatasetSource that provides a URL that the DataRobot AI API will ingest for building a model.
 */
public class DatasetUrlSource implements IDatasetSource, Serializable {
    @JsonInclude
    @JsonProperty("url")
    private URI uri;
    @JsonIgnore
    private String name;
    @JsonIgnore
    private String contentType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    private final static long serialVersionUID = -7529257903952895493L;

    public DatasetUrlSource(String name, URI uri) {
        this.name = name;
        this.uri = uri;
        this.contentType = "text/csv";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getName() {
        return name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getContentType() {
        return this.contentType;
    }

    /**
     * @return The URI of the Datasource
     */
    public URI getURI() {
        return uri;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
