package com.datarobot.model;

import java.io.Serializable;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.impl.DataRobotAIClient;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A reference to a {@code Deployment} on the DataRobot server.
 * 
 * Client code that uses the DataRobot AI API package generally should not construct these objects directly, they should be instantiated by AI API Client methods.
 * 
 * This object may be out of sync with the DataRobot sever, for example, if multiple processes or users have permission to modify or delete it on the server.
 * 
 */
public class Deployment implements Serializable, INeedClient {

	private static final long serialVersionUID = 5897771471386474419L;

	@JsonIgnore
	private IDataRobotAIClient client;
	
	@JsonProperty("url")
	private String url;
	
	@JsonProperty("deploymentId")
	private String deploymentId;
	
	@JsonProperty("target")
	private String target;
	
	@JsonProperty("datarobot-key")
	private String datarobotKey;

	@JsonProperty("modelType")
	private String modelType;
	
	
	public Deployment() {
		
	}
	
	/**
	 * internal
	 */
	public Deployment(String url, String deploymentId, String target, String datarobotKey, String modelType) {
		this.url = url;
		this.deploymentId = deploymentId;
		this.target = target;
		this.datarobotKey = datarobotKey;
		this.modelType = modelType;
	}
	
	/**
	 * internal
	 */
	@Override
	public void setClient(IDataRobotAIClient client) {
		this.client = client;
	}
	
	/**
	 * Get the URL of this {@link Deployment}
	 * 
	 * @return The URL of this deployment
	 */
	public String getUrl() {
		return this.url;
	}
	
	/**
	 * Get the unique identifier of this {@link Deployment}
	 * 
	 * @return The ID of this deployment
	 */
	public String getDeploymentId() {
		return this.deploymentId;
	}
	
	/**
	 * Get the target of this {@link Deployment}
	 * 
	 * @return The target of this deployment
	 */
	public String getTarget() {
		return this.target;
	}
	
	/**
	 * Get the datarobot-key required for predictions associated with this {@link Deployment}
	 * 
	 * @return The datarobot-key of this deployment
	 */
	public String getDataRobotKey() {
		return this.datarobotKey;
	}

	/**
	 * Get the model type associated with this deployment
	 * 
	 * @return The model type of the deployment
	 */
	public String getModelType() {
		return this.modelType;
	}
	
	/**
	 * internal
	 */
	public void setUrl(String url) {
		this.url = url;
	}
	
	/**
	 * internal
	 */
	public void setDeploymentId(String deploymentId) {
		this.deploymentId = deploymentId;
	}
	
	/**
	 * internal
	 */
	public void setTarget(String target) {
		this.target = target;
	}
	
	/**
	 * internal
	 */
	public void setDataRobotKey(String datarobotKey) {
		this.datarobotKey = datarobotKey;
	}

	/**
	 * internal
	 */
	public void setModelType(String modelType) {
		this.modelType = modelType;
	}
	
	@Override
	public String toString() {
		return "Deployment [client=" + client + ", url=" + url + ", deploymentId=" + deploymentId + ", target=" + target
				+ ", datarobotKey=" + datarobotKey + ", modelType=" + modelType + "]";
	}

}
