package com.datarobot.model;

import com.datarobot.util.PrettyPrintingMap;
import com.fasterxml.jackson.annotation.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * The {@code ErrorResponse} object contains Error information when a {@link com.datarobot.impl.ClientException} occurs.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "message",
        "errors",
})
public class ErrorResponse implements Serializable
{
    @JsonIgnore
    private int statusCode;
    @JsonIgnore
    private String statusMessage;
    @JsonProperty("message")
    private String message;
    @JsonProperty("errors")
    private HashMap<String, Object> errors;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    private final static long serialVersionUID = -3485997608478239325L;
    /**
     *
     */
    public ErrorResponse() {
        errors = new HashMap<>();
    }

    /**
     * @return The Status message of the HTTP Response.
     */
    public String getStatusMessage() {
        return statusMessage;
    }

    /**
     * Sets the Status message of the HTTP Response.
     *
     * @param message the message to be set on this {@link ErrorResponse}
     */
    public void setStatusMessage(String message) {
        this.message = message;
    }

    /**
     * @return The HTTP Status code of the HTTP Response.
     */
    public int getStatusCode() {
        return statusCode;
    }

    /**
     * Used to set the HTTPStatus code of the HTTP Response.
     * @param statusCode The HTTP Status code of the current error.
     */
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    /**
     * @return The error message in the response.
     */
    public String getMessage() {
        return message;
    }

    /**
     * @return An array of errors returned from the API.
     */
    public HashMap<String, Object> getErrors() {
        return errors;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(statusCode)
                .append(message)
                .append(errors)
                .append(additionalProperties)
                .toHashCode();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ErrorResponse) == false) {
            return false;
        }
        ErrorResponse rhs = ((ErrorResponse) other);
        return new EqualsBuilder()
                .append(statusCode, rhs.statusCode)
                .append(message, rhs.message)
                .append(errors, rhs.errors)
                .append(additionalProperties, rhs.additionalProperties)
                .isEquals();
    }

    @Override
    public String toString() {
        return String.format("Error %s returned. %s Details:\n%s",
                this.getStatusCode(),
                this.getStatusMessage(),
                new PrettyPrintingMap<>(this.errors));
    }
}