package com.datarobot.model;

import java.io.Serializable;
import java.util.Map;

import com.datarobot.IDataRobotAIClient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A reference to an {@code Evaluation} for a {@link LearningSession} on the DataRobot server.
 * 
 * Client code that uses the DataRobot AI API package generally should not construct these objects directly, they should be instantiated by AI API Client methods.
 * 
 * This object may be out of sync with the DataRobot sever, for example, if multiple processes or users have permission to modify or delete it on the server.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Evaluation implements Serializable, INeedClient {

	private String summary;
	private double score;
	private String label;
	private IDataRobotAIClient client;

	@JsonProperty("evaluation")
	private void unpack(Map<String, Object> evaluation) {
		this.summary = (String) evaluation.get("summary");
		this.score = (Double) evaluation.get("score");
		this.label = (String) evaluation.get("label");
	}
	
	public Evaluation(String summary, Double score, String label) {
		this.summary = summary;
		this.label = label;
		this.score = score;
	}
	
	public Evaluation() {}
	
	private static final long serialVersionUID = 6707596905669868836L;

	@Override
	public void setClient(IDataRobotAIClient client) {
		this.client = client;
	}
	
	public String getSummary() {
		return this.summary;
	}
	
	public double getScore() {
		return this.score;
	}
	
	public String getLabel() {
		return this.label;
	}
	
	@Override
	public String toString() {
		return "Evaluation [summary=" + summary + ", score=" + score + ", label=" + label + ", client=" + client + "]";
	}

}
