package com.datarobot.model;


import com.fasterxml.jackson.annotation.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.HashMap;
import java.util.Map;

/**
 * A reference to a {@code Feature} on the DataRobot server.
 * 
 * Client code that uses the DataRobot AI API package generally should not construct these objects directly, they should be instantiated by AI API Client methods.
 * 
 * This object may be out of sync with the DataRobot sever, for example, if multiple processes or users have permission to modify or delete it on the server.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "name",
        "type"
})
public class Feature {

	@JsonProperty("name")
    private String name;
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    private final static long serialVersionUID = 8489395736150834935L;

    /**
     * Get the name of this {@link Feature}
     * 
     * @return The name of this feature
     */
    public String getName() { return this.name; }

    /**
     * Get the type of this {@link Feature}
     * 
     * @return The type of this feature
     */
    public String getType() { return this.type; }

    /**
     * internal
     */
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * internal
     */
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    /**
     * internal
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(name)
                .append(type)
                .append(additionalProperties)
                .toHashCode();
    }

    /**
     * internal
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Feature) == false) {
            return false;
        }
        Feature rhs = ((Feature) other);
        return new EqualsBuilder()
                .append(name, rhs.name)
                .append(type, rhs.type)
                .append(additionalProperties, rhs.additionalProperties)
                .isEquals();
    }
    
    @Override
	public String toString() {
		return "Feature [name=" + name + ", type=" + type + "]";
	}
}
