package com.datarobot.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;

/**
 * internal
 * 
 * {@code LearnParams} indicate which {@code datasetId} to use to {@code learn}. The {@code target}
 * is the field in the dataset that it will used to learn to predict from.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "datasetId",
        "target"
})
public class LearnParams implements Serializable {

	@JsonProperty("datasetId")
    private String datasetId;
    @JsonProperty("target")
    private String target;
    private final static long serialVersionUID = -6723268743653657L;

    /**
     *
     * @param datasetId The ID of the Dataset used to build the model
     * @param target The Target used for building the model
     */
    public LearnParams(String datasetId, String target) {
        this.datasetId = datasetId;
        this.target = target;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(datasetId)
                .append(target)
                .toHashCode();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LearnParams) == false) {
            return false;
        }
        LearnParams rhs = ((LearnParams) other);
        return new EqualsBuilder()
                .append(datasetId, rhs.datasetId)
                .append(target, rhs.target)
                .isEquals();
    }
    
    @Override
	public String toString() {
		return "LearnParams [datasetId=" + datasetId + ", target=" + target + "]";
	}
}
