package com.datarobot.model;

import com.fasterxml.jackson.annotation.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * A reference to the features of a {@code LearningSession} on the DataRobot server.
 * 
 * Client code that uses the DataRobot AI API package generally should not construct these objects directly, they should be instantiated by AI API Client methods.
 * 
 * This object may be out of sync with the DataRobot sever, for example, if multiple processes or users have permission to modify or delete it on the server.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "id",
        "target",
        "datasetId",
        "features"
})
public class LearningSessionFeatures implements Serializable {

	@JsonProperty("id")
    private String id;
    @JsonProperty("target")
    private String target;
    @JsonProperty("datasetId")
    private String datasetId;
    @JsonProperty("features")
    private List<Feature> features;

    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    private final static long serialVersionUID = -345865434566543456L;

    /**
     * Get the unique identifier for the {@link LearningSession} these {@link LearningSessionFeatures} are associated with
     * 
     * @return The ID of the learning session for these features
     */
    public String getId() {
        return id;
    }

    /**
     * Get the target for the {@link LearningSession} these {@link LearningSessionFeatures} are associated with
     *
     * @return The target of the learning session for these features
     */
    public String getTarget() {
        return target;
    }

    /**
     * Get the unique identifier for the {@link Dataset} these {@link LearningSessionFeatures} are associated with
     * 
     * @return The ID of the dataset for these features
     */
    public String getDatasetId() {
        return datasetId;
    }

    /**
     * Retrieve a list of {@link Feature} objects associated with this {@link LearningSession}
     *
     * @return A list of feature objects
     */
    public List<Feature> getFeatures() {
        return features;
    }

    /**
     * internal
     */
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * internal
     */
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    /**
     * internal
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(id)
                .append(datasetId)
                .append(target)
                .append(features)
                .append(additionalProperties)
                .toHashCode();
    }

    /**
     * internal
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LearningSessionFeatures) == false) {
            return false;
        }
        LearningSessionFeatures rhs = ((LearningSessionFeatures) other);
        return new EqualsBuilder()
                .append(id, rhs.id)
                .append(datasetId, rhs.datasetId)
                .append(target, rhs.target)
                .append(features, rhs.features)
                .append(additionalProperties, rhs.additionalProperties)
                .isEquals();
    }
    
    @Override
	public String toString() {
		return "LearningSessionFeatures [id=" + id + ", target=" + target + ", datasetId=" + datasetId + ", features="
				+ features + "]";
	}
}
