package com.datarobot.model;

import com.datarobot.impl.ClientException;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * internal
 */
public class LearningSessionLearnResponse extends ReturnsLocation implements ILocationResponse  {
    // support different ID's formats on different endpoints
    private Pattern currentIdPattern = Pattern.compile("learningSession|status/([a-f\\d-]{24,36})/$");
    private String statusId;
    private int statusCode;
    private String statusUrl;
    
    @JsonProperty("links")
    private void unpack(Map<String, String> links) throws ClientException {
    	this.statusUrl = (String)links.get("result");
    	this.statusId = parseStatusId(statusUrl);
    }
    
    public String getStatusUrl() {
    	return this.statusUrl;
    }
    

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public int getStatusCode() {
        return statusCode;
    }

    @Override
    public String getStatusId() {
    	return this.statusId;
    }
    
    // Does nothing for now, will refactor in future
    @Override
    public void setStatusId() {
    	String statusUrl = getStatusUrl();
    	try {
			parseIdFromUrl(statusUrl);
		} catch (ClientException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }

    // Will be removed once returns location is refactored correctly
    @Override
    void parseIdFromUrl(String statusUrl) throws ClientException {
        Matcher matchId = currentIdPattern.matcher(statusUrl);
        if (!matchId.find()) {
            throw new ClientException("Invalid id in redirect header.");
        }
        this.statusId = matchId.group(1);
    }
    
    // Will be removed once this & datasets are refactored correctly
    @Override
    public String getObjectId() {
    	return this.statusId;
    }
    
    // Will be removed once this & datasets are refactored correctly
    @Override
    public void setObjectId(String objectId) {
    	
    }
    
    // hack for now - this method replaces parseIdFromUrl which will be removed 
    private String parseStatusId(String statusUrl) throws ClientException {
        Matcher matchId = currentIdPattern.matcher(statusUrl);
        if (!matchId.find()) {
            throw new ClientException("Invalid id in redirect header.");
        }
        return matchId.group(1);
    }
}
