package com.datarobot.model;

import com.fasterxml.jackson.annotation.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A reference to a list of {@code LearningSession} objects on the DataRobot server connected to an account.
 * 
 * Client code that uses the DataRobot AI API package generally should not construct these objects directly, they should be instantiated by AI API Client methods.
 * 
 * This object may be out of sync with the DataRobot sever, for example, if multiple processes or users have permission to modify or delete it on the server.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "data"
})
public class LearningSessionList extends Paged implements Serializable {

	@JsonProperty("data")
    private List<LearningSession> items = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    private final static long serialVersionUID = -3554899023423234289L;

    /**
     * Retrieve a list of {@link LearningSession} objects that have been uploaded to this account
     *
     * @return A list of learning session objects
     */
    public List<LearningSession> getItems() {
        return items;
    }

    /**
     * internal
     */
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * internal
     */
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    /**
     * internal
     */
    @Override
    public int hashCode() {

        return new HashCodeBuilder()
                .append(items)
                .append(additionalProperties)
                .toHashCode();
    }

    /**
     * internal
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LearningSessionList) == false) {
            return false;
        }
        LearningSessionList rhs = ((LearningSessionList) other);
        return new EqualsBuilder()
                .append(items, rhs.items)
                .append(additionalProperties, rhs.additionalProperties)
                .isEquals();
    }
    
    @Override
	public String toString() {
		return "LearningSessionList";
	}
}
