package com.datarobot.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * A reference to a list of {@code Output} objects on the DataRobot server connected to an account.
 * 
 * Client code that uses the DataRobot AI API package generally should not construct these objects directly, they should be instantiated by AI API Client methods.
 * 
 * This object may be out of sync with the DataRobot sever, for example, if multiple processes or users have permission to modify or delete it on the server.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "data"
})
public class OutputList extends Paged implements Serializable {


	private static final long serialVersionUID = 7790103068708124455L;
	@JsonProperty("data")
    private List<Output> items = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    
    /**
     * Retrieve a list of {@link Output} objects that are connected to this account
     *
     * @return A list of output objects
     */
    public List<Output> getItems(){
    	return items;
    }
    
    /**
     * internal
     */
	@JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

	/**
	 * internal
	 */
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }


    /**
     * internal
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(items).append(additionalProperties).toHashCode();
    }


    /**
     * internal
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OutputList) == false) {
            return false;
        }
        OutputList rhs = ((OutputList) other);
        return new EqualsBuilder().append(items, rhs.items).append(additionalProperties, rhs.additionalProperties).isEquals();
    }
    
    @Override
	public String toString() {
		return "OutputList";
	}

}
