package com.datarobot.model;
import com.datarobot.impl.ClientException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.Map;

/**
 * A base class inherited by other {@code List} objects that add Paging capabilities through properties such as
 * {@code count}, {@code previous}, and {@code next}.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "total",
        "links"
})
public class Paged implements Serializable {

	@JsonProperty("total")
    private int total;
    private String previous;
    private String next;
    @JsonProperty("links")
    private void unpack(Map<String, String> links) throws ClientException {
    	this.next = links.get("next");
    	this.previous = links.get("previous");
    }

    /**
     * For DataRobot AI API list objects, this property will indicate the URL of the current page.
     * @return The current page number.
     */
    public int getCount() {
        return total;
    }

    /**
     * For DataRobot AI API list objects, this property will indicate the URL of the previous page.
     * @return The previous page.
     */
    public String getPrevious() {
        return previous;
    }

    /**
     * For DataRobot AI API list objects, this property will indicate the URL of the next page.
     * @return The next page.
     */
    public String getNext() {
        return next;
    }

    /**
     * internal
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(total)
                .append(previous)
                .append(next)
                .toHashCode();
    }

    /**
     * internal
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Paged) == false) {
            return false;
        }
        Paged rhs = ((Paged) other);
        return new EqualsBuilder()
                .append(total, rhs.total)
                .append(previous, rhs.previous)
                .append(next, rhs.next)
                .isEquals();
    }
    
    @Override
	public String toString() {
		return "Paged [total=" + total + ", previous=" + previous + ", next=" + next + "]";
	}
}
