package com.datarobot.model;

import com.fasterxml.jackson.annotation.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * {@code Ping} can be used to test both Network Connectivity and if a Valid API Key was submitted. The
 * {@code response} will contain {@code 'pong'} if all goes well.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "token",
        "response"
})
public class Ping implements Serializable {
    @JsonProperty("token")
    private String token;
    @JsonProperty("response")
    private String response;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    private final static long serialVersionUID = 3428789432750247058L;

    /**
     * Not used.
     *
     * @return will always return null/empty.
     */
    public String getToken() {
        return this.token;
    }

    /**
     * Will contain {@code 'pong'} if all goes well with the {@code ping()} request.
     *
     * @return a string that says 'pong'
     */
    public String getResponse() {
        return this.response;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(token)
                .append(response)
                .append(additionalProperties)
                .toHashCode();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Ping) == false) {
            return false;
        }
        Ping rhs = ((Ping) other);
        return new EqualsBuilder()
                .append(token, rhs.token)
                .append(response, rhs.response)
                .append(additionalProperties, rhs.additionalProperties)
                .isEquals();
    }
}
