package com.datarobot.model;


import com.fasterxml.jackson.annotation.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A reference to a {@code Prediction} on the DataRobot server.
 * 
 * Client code that uses the DataRobot AI API package generally should not construct these objects directly, they should be instantiated by AI API Client methods.
 * 
 * This object may be out of sync with the DataRobot sever, for example, if multiple processes or users have permission to modify or delete it on the server.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "rowId",
        "prediction",
        "predictionThreshold",
        "predictionValues"
})
public class Prediction implements Serializable {

	@JsonProperty("rowId")
    private String rowId;
    @JsonProperty("prediction")
    private String prediction;
    @JsonProperty("predictionThreshold")
    private String predictionThreshold;
    @JsonProperty("predictionValues")
    private List<HashMap<String, Object>> predictionValues;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
    private final static long serialVersionUID = 5698493279843566501L;

    /**
     * Get the row number for the data associated with this {@link Prediction} 
     * 
     * @return The row number for this prediction data
     */
    public String getRowId() {
        return rowId;
    }

    /**
     * Get the {@link Prediction} value (either a predicted class for classification or a predict value for regression)
     *
     * @return The prediction value 
     */
    public String getPrediction() {
        return prediction;
    }

    /**
     * Get details on a {@link Prediction} (i.e. the probability of each label for classification)
     *
     * @return The prediction value details
     */
    public List<HashMap<String, Object>> getPredictionValues() {
        return predictionValues;
    }

    /**
     * internal
     */
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * internal
     */
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    /**
     * internal
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(rowId)
                .append(prediction)
                .append(predictionThreshold)
                .append(predictionValues)
                .append(additionalProperties)
                .toHashCode();
    }

    /**
     * internal
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Prediction) == false) {
            return false;
        }
        Prediction rhs = ((Prediction) other);
        return new EqualsBuilder().append(rowId, rhs.rowId)
                .append(prediction, rhs.prediction)
                .append(predictionThreshold, rhs.predictionThreshold)
                .append(predictionValues, rhs.predictionValues)
                .append(additionalProperties, rhs.additionalProperties)
                .isEquals();
    }
    
    @Override
	public String toString() {
		return "Prediction [rowId=" + rowId + ", prediction=" + prediction + ", predictionThreshold="
				+ predictionThreshold + ", predictionValues=" + predictionValues + "]";
	}
}
