package com.datarobot.model;

import com.datarobot.impl.ClientException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.client.http.HttpHeaders;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * This Abstract class can be added to any model tied to an HTTP Response that has a Location header.
 */
public abstract class ReturnsLocation {
    @JsonIgnore
    private URI location;

    public URI getLocation() {
        return this.location;
    }

    abstract void parseIdFromUrl(String location) throws ClientException;

    public void AssignLocation(HttpHeaders headers) throws ClientException {
        if (headers != null) {
            if (headers.containsKey("location")) {
                try {
                    this.location = new URI(headers.getFirstHeaderStringValue("location"));
                    this.parseIdFromUrl(location.toString());
                } catch (URISyntaxException use) {}
            }
        }
    }
}
