/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.impl.ClientException;
import com.datarobot.model.AICreationResponse;
import com.datarobot.model.Deployment;
import com.datarobot.model.ErrorResponse;
import com.datarobot.model.INeedClient;
import com.datarobot.util.Action;
import com.datarobot.util.HttpMethod;
import com.datarobot.util.JacksonMapperHttpContent;
import com.datarobot.util.JacksonMapperParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.ObjectParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiConnection {
    private IDataRobotAIClient client;
    private String key;
    private String endpoint;
    private HttpTransport httpTransport;
    private ObjectMapper mapper = new ObjectMapper();
    public static final String JSON_TYPE = "application/json";
    private static final Logger logger = LogManager.getLogger(ApiConnection.class);
    private int readTimeout = 300000;
    private HttpRequestFactory requestFactory;

    ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    String getApiKey() {
        return this.key;
    }

    public ApiConnection(String endpoint, String key, IDataRobotAIClient client) {
        this(endpoint, key, (HttpTransport)new NetHttpTransport(), client);
    }

    ApiConnection(String endpoint, String key, HttpTransport httpTransport, IDataRobotAIClient client) {
        this.client = client;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport;
        this.key = key;
        this.mapper.registerModule((Module)new JodaModule());
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.requestFactory = httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setSuppressUserAgentSuffix(true);
                request.setParser((ObjectParser)new JacksonMapperParser(ApiConnection.this.getObjectMapper()));
                request.setFollowRedirects(false);
                request.setThrowExceptionOnExecuteError(false);
                request.setReadTimeout(ApiConnection.this.readTimeout);
                request.setHeaders(new HttpHeaders().setAuthorization("Bearer " + ApiConnection.this.getApiKey()).setUserAgent("DataRobotAIClient-Java-API-Client/1.0.0"));
            }
        });
    }

    public void get(String path, Map<String, Object> parameters, Action<HttpRequest, HttpResponse> httpMessageTransformer, OutputStream output) throws ClientException {
        this.get(path, parameters, httpMessageTransformer, output, null);
    }

    public void get(String path, Map<String, Object> parameters, Action<HttpRequest, HttpResponse> httpMessageTransformer, OutputStream output, String acceptType) throws ClientException {
        try {
            if (StringUtils.isEmpty((CharSequence)acceptType)) {
                acceptType = JSON_TYPE;
            }
            GenericUrl uri = this.prepareURI(path, parameters);
            HttpRequest request = this.requestFactory.buildGetRequest(uri);
            request.getHeaders().setAccept(acceptType);
            this.makeRequest(request, httpMessageTransformer, output);
        }
        catch (URISyntaxException uris) {
            throw new ClientException("Invalid URI.", uris);
        }
        catch (IOException ioe) {
            throw new ClientException("Internal Error.", ioe);
        }
    }

    public <T> T get(Class<T> type, String path, Map<String, Object> parameters, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        return this.get(type, path, parameters, httpMessageTransformer, (String)null);
    }

    public <T> T get(Class<T> type, String path, Map<String, Object> parameters, Action<HttpRequest, HttpResponse> httpMessageTransformer, String acceptType) throws ClientException {
        try {
            if (StringUtils.isEmpty((CharSequence)acceptType)) {
                acceptType = JSON_TYPE;
            }
            GenericUrl uri = this.prepareURI(path, parameters);
            HttpRequest request = this.requestFactory.buildGetRequest(uri);
            request.getHeaders().setAccept(acceptType);
            return this.makeRequest(type, request, httpMessageTransformer);
        }
        catch (URISyntaxException uris) {
            throw new ClientException("Invalid URI.", uris);
        }
        catch (IOException ioe) {
            throw new ClientException("Internal Error.", ioe);
        }
    }

    public HttpHeaders head(String path, Map<String, Object> parameters, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        String acceptType = JSON_TYPE;
        try {
            GenericUrl uri = this.prepareURI(path, parameters);
            HttpRequest request = this.requestFactory.buildHeadRequest(uri);
            request.getHeaders().setAccept(acceptType);
            return this.makeRequest(request, httpMessageTransformer).getHeaders();
        }
        catch (URISyntaxException uris) {
            throw new ClientException("Invalid URI.", uris);
        }
        catch (IOException ioe) {
            throw new ClientException("Internal Error.", ioe);
        }
    }

    public <T> T put(Class<T> type, String path, Map<String, Object> parameters, Object body, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        return this.sendObjectContent(type, path, parameters, HttpMethod.PUT, body, httpMessageTransformer);
    }

    public <T> T putFile(Class<T> type, String path, Map<String, Object> parameters, InputStream body, String streamName, String contentType, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        return this.sendFileContent(type, path, parameters, HttpMethod.PUT, body, streamName, contentType, httpMessageTransformer);
    }

    public <T> T putStream(Class<T> type, String path, Map<String, Object> parameters, File body, String contentType, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        return this.sendStreamContent(type, path, parameters, HttpMethod.PUT, body, contentType, httpMessageTransformer);
    }

    public <T> T post(Class<T> type, String path, Map<String, Object> parameters, Object body, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        return this.sendObjectContent(type, path, parameters, HttpMethod.POST, body, httpMessageTransformer);
    }

    public <T> T postStream(Class<T> type, String path, Map<String, Object> parameters, File body, String contentType, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        return this.sendStreamContent(type, path, parameters, HttpMethod.POST, body, contentType, httpMessageTransformer);
    }

    public <T> T postFile(Class<T> type, String path, Map<String, Object> parameters, String streamName, InputStream body, String contentType, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        return this.sendFileContent(type, path, parameters, HttpMethod.POST, body, streamName, contentType, httpMessageTransformer);
    }

    private <T> T sendObjectContent(Class<T> type, String path, Map<String, Object> parameters, HttpMethod method, Object body, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        String acceptType = JSON_TYPE;
        try {
            GenericUrl uri = this.prepareURI(path, parameters);
            HttpRequest request = null;
            JacksonMapperHttpContent contentSend = new JacksonMapperHttpContent(this.getObjectMapper(), body);
            switch (method) {
                case PUT: {
                    request = this.requestFactory.buildPutRequest(uri, (HttpContent)contentSend);
                    break;
                }
                case POST: {
                    request = this.requestFactory.buildPostRequest(uri, (HttpContent)contentSend);
                }
            }
            request.getHeaders().setAccept(acceptType).setContentType(acceptType);
            return this.makeRequest(type, request, httpMessageTransformer);
        }
        catch (URISyntaxException uris) {
            throw new ClientException("Invalid URI.", uris);
        }
        catch (IOException ioe) {
            throw new ClientException("Internal Error.", ioe);
        }
    }

    private <T> T sendStreamContent(Class<T> type, String path, Map<String, Object> parameters, HttpMethod method, File file, String contentType, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        String acceptType = JSON_TYPE;
        try {
            GenericUrl uri = this.prepareURI(path, parameters);
            HttpRequest request = null;
            FileContent body = new FileContent("text/csv", file);
            switch (method) {
                case PUT: {
                    request = this.requestFactory.buildPutRequest(uri, (HttpContent)body);
                    break;
                }
                case POST: {
                    request = this.requestFactory.buildPostRequest(uri, (HttpContent)body);
                }
            }
            if (path.contains("/predApi/v1.0/")) {
                request.getHeaders().setAccept(acceptType).setContentType(contentType).set("datarobot-key", (Object)((Deployment)parameters.get("deployment")).getDataRobotKey());
            } else {
                request.getHeaders().setAccept(acceptType).setContentType(contentType);
            }
            return this.makeRequest(type, request, httpMessageTransformer);
        }
        catch (URISyntaxException use) {
            throw new ClientException("Invalid URI.", use);
        }
        catch (IOException ioe) {
            throw new ClientException("Internal Error.", ioe);
        }
    }

    private <T> T sendFileContent(Class<T> type, String path, Map<String, Object> parameters, HttpMethod method, InputStream body, String streamName, String contentType, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        String acceptType = JSON_TYPE;
        try {
            GenericUrl uri = this.prepareURI(path, parameters);
            HttpRequest request = null;
            MultipartContent.Part part = new MultipartContent.Part().setContent((HttpContent)new InputStreamContent(contentType, body)).setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"file\"; filename=\"%s\"", streamName)));
            MultipartContent content = new MultipartContent().setMediaType(new HttpMediaType("multipart/form-data").setParameter("boundary", UUID.randomUUID().toString())).addPart(part);
            switch (method) {
                case PUT: {
                    request = this.requestFactory.buildPutRequest(uri, (HttpContent)content);
                    break;
                }
                case POST: {
                    request = this.requestFactory.buildPostRequest(uri, (HttpContent)content);
                }
            }
            request.getHeaders().setAccept(acceptType);
            return this.makeRequest(type, request, httpMessageTransformer);
        }
        catch (URISyntaxException use) {
            throw new ClientException("Invalid URI.", use);
        }
        catch (IOException ioe) {
            throw new ClientException("Internal Error.", ioe);
        }
    }

    public void delete(String path, Map<String, Object> parameters, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        String acceptType = JSON_TYPE;
        try {
            GenericUrl uri = this.prepareURI(path, parameters);
            HttpRequest request = this.requestFactory.buildDeleteRequest(uri);
            request.getHeaders().setAccept(acceptType);
            HttpResponse response = this.makeRequest(request, httpMessageTransformer);
            response.disconnect();
        }
        catch (URISyntaxException uris) {
            throw new ClientException("Invalid URI.", uris);
        }
        catch (IOException ioe) {
            throw new ClientException("Internal Error.", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T makeRequest(Class<T> type, HttpRequest request, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        Object object = null;
        try {
            HttpResponse response = this.makeRequest(request, httpMessageTransformer);
            try {
                if (response.getStatusCode() == 200 || response.getStatusCode() == 201 && type.getTypeName().equals(AICreationResponse.class.getName()) || response.getStatusCode() == 202) {
                    object = response.parseAs(type);
                }
                if (object == null) {
                    object = type.newInstance();
                }
                if (INeedClient.class.isAssignableFrom(object.getClass())) {
                    ((INeedClient)object).setClient(this.client);
                }
                Object object2 = object;
                return (T)object2;
            }
            finally {
                response.disconnect();
            }
        }
        catch (HttpResponseException hre) {
            throw this.GenerateClientException(hre);
        }
        catch (IOException ioe) {
            throw new ClientException("IO Error while making HTTP Request", ioe);
        }
        catch (ClientException nce) {
            throw nce;
        }
        catch (Exception e) {
            throw new ClientException("Error while making HTTP Request: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRequest(HttpRequest request, Action<HttpRequest, HttpResponse> httpMessageTransformer, OutputStream output) throws ClientException {
        try {
            HttpResponse response = this.makeRequest(request, httpMessageTransformer);
            try {
                response.download(output);
            }
            finally {
                response.disconnect();
            }
        }
        catch (HttpResponseException hre) {
            throw this.GenerateClientException(hre);
        }
        catch (IOException ioe) {
            throw new ClientException("IO Error while making HTTP Request: " + ioe.getMessage());
        }
    }

    private HttpResponse makeRequest(HttpRequest request, Action<HttpRequest, HttpResponse> httpMessageTransformer) throws ClientException {
        try {
            if (httpMessageTransformer != null) {
                httpMessageTransformer.invoke(request, null);
            }
            logger.debug(String.format("HTTP %s Request: %s", request.getRequestMethod(), request.getUrl().toString()));
            HttpResponse response = request.execute();
            logger.debug(String.format("HTTP %s: %s", response.getStatusCode(), request.getUrl().toString()));
            if (!response.isSuccessStatusCode() && response.getStatusCode() != 301 && response.getStatusCode() != 303) {
                throw new HttpResponseException(response);
            }
            if (httpMessageTransformer != null) {
                httpMessageTransformer.invoke(request, response);
            }
            return response;
        }
        catch (HttpResponseException hre) {
            throw this.GenerateClientException(hre);
        }
        catch (IOException ioe) {
            throw new ClientException("IO Error while making HTTP Request: " + ioe.getMessage());
        }
        catch (Exception e) {
            throw new ClientException("Error while making HTTP Request: " + e.getMessage());
        }
    }

    GenericUrl prepareURI(String path, Map<String, Object> parameters) throws URISyntaxException {
        GenericUrl url;
        if (path.contains("predApi/v1.0/")) {
            String fullPath = path + "/";
            URI uri = new URI(fullPath);
            GenericUrl url2 = new GenericUrl(fullPath);
            return url2;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
            URI uri = new URI(this.endpoint + path);
            url = new GenericUrl(this.endpoint + path);
        } else {
            URI uri = new URI(this.endpoint + path);
            url = new GenericUrl(this.endpoint + path);
        }
        if (path.contains("predApi/v1.0/")) {
            return url;
        }
        if (parameters != null && parameters.size() != 0) {
            url.putAll(parameters);
        }
        return url;
    }

    private ClientException GenerateClientException(HttpResponseException responseException) {
        try {
            ErrorResponse errorResponse = (ErrorResponse)this.mapper.readValue(responseException.getContent(), ErrorResponse.class);
            errorResponse.setStatusCode(responseException.getStatusCode());
            errorResponse.setStatusMessage(responseException.getStatusMessage());
            logger.error(errorResponse.toString());
            if (errorResponse != null) {
                StringBuilder errorBuilder = new StringBuilder();
                errorBuilder.append("API Error: ").append(errorResponse.getStatusCode()).append(" -");
                if (errorResponse.getMessage() != null) {
                    errorBuilder.append(" ").append(errorResponse.getMessage());
                }
                if (errorResponse.getStatusMessage() != null) {
                    errorBuilder.append(" ").append(errorResponse.getStatusMessage());
                }
                return new ClientException(errorBuilder.toString(), errorResponse, (Exception)((Object)responseException));
            }
            return new ClientException("API Error: " + errorResponse.getStatusCode() + " - no details provided.", responseException.getStatusCode(), (Exception)((Object)responseException));
        }
        catch (IOException ioe) {
            ClientException nce = new ClientException("Error processing error response content.", (Exception)((Object)responseException));
            try {
                ErrorResponse e = new ErrorResponse();
                e.setAdditionalProperty("Error Content", responseException.getContent());
                e.setStatusCode(responseException.getStatusCode());
                nce.setStatusCode(responseException.getStatusCode());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return nce;
        }
    }
}

