/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IAIClient;
import com.datarobot.IDataRobotAIClient;
import com.datarobot.IDatasetClient;
import com.datarobot.ILearningSessionClient;
import com.datarobot.IPredictionClient;
import com.datarobot.IStatusClient;
import com.datarobot.impl.AIClient;
import com.datarobot.impl.ApiConnection;
import com.datarobot.impl.Argument;
import com.datarobot.impl.ClientException;
import com.datarobot.impl.DatasetClient;
import com.datarobot.impl.LearningSessionClient;
import com.datarobot.impl.PredictionClient;
import com.datarobot.impl.StatusClient;
import com.datarobot.model.AI;
import com.datarobot.model.Ping;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataRobotAIClient
implements IDataRobotAIClient {
    private String key;
    private String configuredUrl;
    private ApiConnection apiConnection;
    private IDatasetClient data;
    private IStatusClient status;
    private ILearningSessionClient learning;
    private IPredictionClient prediction;
    private IAIClient ais;
    private static final Logger logger = LogManager.getLogger(DataRobotAIClient.class);
    private Action<HttpRequest, HttpResponse> httpMessageTransformer;
    public static final String CLIENT_VERSION = "DataRobotAIClient-Java-API-Client/1.0.0";
    public static final String BASE_URL = "https://developers.datarobot.com/aiapi/";

    public String getApiKey() {
        return this.key;
    }

    public String getConfiguredUrl() {
        return this.configuredUrl != null ? this.configuredUrl : BASE_URL;
    }

    public DataRobotAIClient() {
        this(System.getenv("API_KEY"));
    }

    public DataRobotAIClient(String key) {
        this(key, BASE_URL, (HttpTransport)new NetHttpTransport());
    }

    public DataRobotAIClient(String key, String endpoint) {
        this(key, endpoint, (HttpTransport)new NetHttpTransport());
    }

    public DataRobotAIClient(String key, String endpoint, HttpTransport httpTransport) throws IllegalArgumentException {
        this.key = key;
        if (endpoint == null || endpoint.isEmpty()) {
            throw new IllegalArgumentException("No value was provided for the endpoint. If you do not know the value, use the ctor with the api key only");
        }
        if (!endpoint.endsWith("/")) {
            endpoint = endpoint + "/";
        }
        this.configuredUrl = endpoint;
        this.apiConnection = new ApiConnection(endpoint, key, httpTransport, this);
        this.data = new DatasetClient(this);
        this.status = new StatusClient(this);
        this.learning = new LearningSessionClient(this);
        this.prediction = new PredictionClient(this);
        this.ais = new AIClient(this);
    }

    @Override
    public ApiConnection getConnection() {
        return this.apiConnection;
    }

    @Override
    public Action<HttpRequest, HttpResponse> getHttpMessageTransformer() {
        return this.httpMessageTransformer;
    }

    @Override
    public void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer) {
        this.httpMessageTransformer = httpMessageTransformer;
        this.UpdateChildClientTransformers();
    }

    private void UpdateChildClientTransformers() {
        if (this.data.getHttpMessageTransformer() == null) {
            this.data.setHttpMessageTransformer(this.httpMessageTransformer);
        }
        if (this.status.getHttpMessageTransformer() == null) {
            this.status.setHttpMessageTransformer(this.httpMessageTransformer);
        }
        if (this.learning.getHttpMessageTransformer() == null) {
            this.learning.setHttpMessageTransformer(this.httpMessageTransformer);
        }
        if (this.prediction.getHttpMessageTransformer() == null) {
            this.learning.setHttpMessageTransformer(this.httpMessageTransformer);
        }
        if (this.ais.getHttpMessageTransformer() == null) {
            this.ais.setHttpMessageTransformer(this.httpMessageTransformer);
        }
    }

    @Override
    public IDatasetClient data() {
        return this.data;
    }

    @Override
    public IStatusClient status() {
        return this.status;
    }

    @Override
    public IPredictionClient predictions() {
        return this.prediction;
    }

    @Override
    public IAIClient ais() {
        return this.ais;
    }

    @Override
    public ILearningSessionClient learning() {
        return this.learning;
    }

    @Override
    public Ping ping() throws ClientException {
        return this.apiConnection.get(Ping.class, "/ping", null, this.httpMessageTransformer);
    }

    @Override
    public AI createAI(String name) throws ClientException, InterruptedException {
        Argument.IsNotNullOrEmpty(name, "name");
        return this.ais.createAI(name);
    }

    public String toString() {
        return "DataRobotAIClient";
    }
}

