/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.ILearningSessionClient;
import com.datarobot.impl.Argument;
import com.datarobot.impl.ClientException;
import com.datarobot.impl.StatusTask;
import com.datarobot.model.Deployment;
import com.datarobot.model.Evaluation;
import com.datarobot.model.IDoGetCallback;
import com.datarobot.model.LearnParams;
import com.datarobot.model.LearningSession;
import com.datarobot.model.LearningSessionFeatures;
import com.datarobot.model.LearningSessionLearnResponse;
import com.datarobot.model.LearningSessionList;
import com.datarobot.model.PagingParams;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class LearningSessionClient
implements ILearningSessionClient,
IDoGetCallback<LearningSession> {
    private IDataRobotAIClient client;
    private Action<HttpRequest, HttpResponse> httpMessageTransformer = null;
    private final ExecutorService pool = Executors.newFixedThreadPool(10);

    public LearningSessionClient(IDataRobotAIClient client) {
        this.client = client;
    }

    @Override
    public Action<HttpRequest, HttpResponse> getHttpMessageTransformer() {
        return this.httpMessageTransformer;
    }

    @Override
    public void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer) {
        this.httpMessageTransformer = httpMessageTransformer;
    }

    @Override
    public LearningSession get(String id) throws ClientException {
        Argument.IsNotNullOrEmpty(id, "id");
        return this.client.getConnection().get(LearningSession.class, "learningSessions/" + id + "/", null, this.httpMessageTransformer);
    }

    @Override
    public LearningSessionList list() throws ClientException {
        return this.list(null);
    }

    @Override
    public LearningSessionList list(PagingParams params) throws ClientException {
        Map<String, Object> parameters = null;
        if (params != null) {
            parameters = params.toParameters();
        }
        LearningSessionList list = this.client.getConnection().get(LearningSessionList.class, "learningSessions/", parameters, this.httpMessageTransformer);
        for (LearningSession ls : list.getItems()) {
            ls.setClient(this.client);
        }
        return list;
    }

    @Override
    public void delete(String id) throws ClientException {
        Argument.IsNotNullOrEmpty(id, "id");
        this.client.getConnection().delete("learningSessions/" + id + "/", null, this.httpMessageTransformer);
    }

    @Override
    public StatusTask<LearningSession> learn(String datasetId, String target) throws ClientException {
        Argument.IsNotNullOrEmpty(datasetId, "datasetId");
        Argument.IsNotNullOrEmpty(target, "target");
        return this.learnTask(datasetId, target);
    }

    @Override
    public Future<LearningSession> startLearn(String datasetId, String target) throws ClientException {
        Argument.IsNotNullOrEmpty(datasetId, "datasetId");
        Argument.IsNotNullOrEmpty(target, "target");
        final StatusTask<LearningSession> task = this.learnTask(datasetId, target);
        return this.pool.submit(new Callable<LearningSession>(){

            @Override
            public LearningSession call() throws ClientException, InterruptedException {
                return (LearningSession)task.getResult();
            }
        });
    }

    private StatusTask<LearningSession> learnTask(String datasetId, String target) throws ClientException {
        LearnParams params = new LearnParams(datasetId, target);
        LearningSessionLearnResponse learnResponse = this.client.getConnection().post(LearningSessionLearnResponse.class, "learningSessions/", null, params, this.httpMessageTransformer);
        return new StatusTask<LearningSession>(this.client, learnResponse, this);
    }

    @Override
    public LearningSessionFeatures getFeatures(String learningSessionId) throws ClientException {
        Argument.IsNotNullOrEmpty(learningSessionId, "learningSessionId");
        return this.client.getConnection().get(LearningSessionFeatures.class, "learningSessions/" + learningSessionId + "/features/", null, this.httpMessageTransformer);
    }

    @Override
    public Deployment getDeployment(String learningSessionId) throws ClientException {
        Argument.IsNotNullOrEmpty(learningSessionId, "learningSessionId");
        String url = "learningSessions/" + learningSessionId + "/deployment/";
        return this.client.getConnection().get(Deployment.class, url, null, this.httpMessageTransformer);
    }

    @Override
    public Evaluation getEvaluation(String learningSessionId) throws ClientException {
        Argument.IsNotNullOrEmpty(learningSessionId, "learningSessionId");
        LearningSession ls = this.get(learningSessionId);
        return ls.getEvaluation();
    }

    public String toString() {
        return "LearningSessionClient";
    }
}

