/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.IPredictionClient;
import com.datarobot.impl.Argument;
import com.datarobot.impl.ClientException;
import com.datarobot.model.Deployment;
import com.datarobot.model.Output;
import com.datarobot.model.PredictionList;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;

public class PredictionClient
implements IPredictionClient {
    private IDataRobotAIClient client;
    private Action<HttpRequest, HttpResponse> httpMessageTransformer = null;

    public PredictionClient(IDataRobotAIClient client) {
        this.client = client;
    }

    @Override
    public Action<HttpRequest, HttpResponse> getHttpMessageTransformer() {
        return this.httpMessageTransformer;
    }

    @Override
    public void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer) {
        this.httpMessageTransformer = httpMessageTransformer;
    }

    @Override
    public PredictionList deploymentPredict(Deployment deployment, String sourceFile) throws ClientException, FileNotFoundException {
        Argument.IsNotNull(deployment, "deployment");
        Argument.IsNotNullOrEmpty(sourceFile, "sourceFile");
        return this.makePredictionRequest(sourceFile, deployment);
    }

    @Override
    public PredictionList aiPredict(String aiId, String target, String data) throws ClientException, FileNotFoundException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Argument.IsNotNullOrEmpty(target, "target");
        Argument.IsNotNullOrEmpty(data, "data");
        Output output = this.client.ais().getOutput(aiId, target);
        Deployment deployment = new Deployment(output.getUrl(), output.getDeploymentId(), output.getTarget(), output.getDataRobotKey(), output.getModelType());
        return this.makePredictionRequest(data, deployment);
    }

    private PredictionList makePredictionRequest(String sourceFile, Deployment deployment) throws FileNotFoundException, ClientException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("deployment", deployment);
        File predictionFile = new File(sourceFile);
        return this.client.getConnection().postStream(PredictionList.class, deployment.getUrl(), parameters, predictionFile, "text/csv", this.httpMessageTransformer);
    }

    public String toString() {
        return "PredictionClient";
    }
}

