/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.IStatusClient;
import com.datarobot.impl.Argument;
import com.datarobot.impl.ClientException;
import com.datarobot.model.PagingParams;
import com.datarobot.model.Status;
import com.datarobot.model.StatusList;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.util.Map;

public class StatusClient
implements IStatusClient {
    private IDataRobotAIClient client;
    private Action<HttpRequest, HttpResponse> httpMessageTransformer = null;

    public StatusClient(IDataRobotAIClient client) {
        this.client = client;
    }

    @Override
    public Action<HttpRequest, HttpResponse> getHttpMessageTransformer() {
        return this.httpMessageTransformer;
    }

    @Override
    public void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer) {
        this.httpMessageTransformer = httpMessageTransformer;
    }

    @Override
    public StatusList list() throws ClientException {
        return this.list(null);
    }

    @Override
    public StatusList list(PagingParams params) throws ClientException {
        Map<String, Object> parameters = null;
        if (params != null) {
            parameters = params.toParameters();
        }
        return this.client.getConnection().get(StatusList.class, "status/", parameters, this.httpMessageTransformer);
    }

    @Override
    public Status get(String statusId) throws ClientException {
        Argument.IsNotNullOrEmpty(statusId, "statusId");
        return this.client.getConnection().get(Status.class, "status/" + statusId + "/", null, this.httpMessageTransformer);
    }

    public String toString() {
        return "StatusClient";
    }
}

