/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.model;

import com.datarobot.impl.ClientException;
import com.datarobot.model.ILocationResponse;
import com.datarobot.model.ReturnsLocation;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"statusId", "status", "code", "description", "created", "message", "statusType", "links"})
public class Status
extends ReturnsLocation
implements Serializable,
ILocationResponse {
    @JsonIgnore
    private Pattern statusIdPattern = Pattern.compile("status/([a-f0-9-]{36})/$");
    @JsonIgnore
    private static final long serialVersionUID = 7155748365180452743L;
    @JsonProperty(value="statusId")
    private String statusId;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="created")
    private DateTime created;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="statusType")
    private String statusType;
    private String result;
    @JsonIgnore
    private int statusCode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="links")
    private void unpack(Map<String, String> links) throws ClientException {
        if (links.containsKey("result")) {
            this.result = links.get("result");
        }
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public String getId() {
        return this.getStatusId();
    }

    public URI getResult() {
        return URI.create(this.result);
    }

    @Override
    public String getStatusId() {
        return this.statusId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getCreatedOn() {
        return this.created;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStatusType() {
        return this.statusType;
    }

    @Override
    public URI getLocation() {
        return this.getResult();
    }

    @Override
    public void setStatusId() {
    }

    public void setResult(String result) {
        result = this.result;
    }

    @Override
    public String getObjectId() {
        String msg = "This will never be called";
        return msg;
    }

    @Override
    public void setObjectId(String objectId) {
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.statusId).append((Object)this.status).append((Object)this.code).append((Object)this.description).append((Object)this.created).append((Object)this.message).append((Object)this.statusType).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Status)) {
            return false;
        }
        Status rhs = (Status)other;
        return new EqualsBuilder().append((Object)this.statusId, (Object)rhs.statusId).append((Object)this.status, (Object)rhs.status).append((Object)this.code, (Object)rhs.code).append((Object)this.description, (Object)rhs.description).append((Object)this.created, (Object)rhs.created).append((Object)this.message, (Object)rhs.message).append((Object)this.statusType, (Object)rhs.statusType).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    @Override
    void parseIdFromUrl(String location) throws ClientException {
        this.statusId = this.stripStatusId(location);
    }

    private String stripStatusId(String location) throws ClientException {
        Matcher statusId = this.statusIdPattern.matcher(location);
        if (statusId.find()) {
            return statusId.group(1);
        }
        return null;
    }

    public String toString() {
        return "Status [statusId=" + this.statusId + ", status=" + this.status + ", code=" + this.code + ", description=" + this.description + ", created=" + this.created + ", message=" + this.message + ", statusType=" + this.statusType + ", result=" + this.result + ", statusCode=" + this.statusCode + "]";
    }
}

