/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IAIClient;
import com.datarobot.IDataRobotAIClient;
import com.datarobot.impl.Argument;
import com.datarobot.impl.ClientException;
import com.datarobot.model.AI;
import com.datarobot.model.AIBody;
import com.datarobot.model.AICreationResponse;
import com.datarobot.model.AIEmptyResponse;
import com.datarobot.model.AIList;
import com.datarobot.model.IDoGetCallback;
import com.datarobot.model.LearningSession;
import com.datarobot.model.LearningSessionList;
import com.datarobot.model.Output;
import com.datarobot.model.OutputFeatures;
import com.datarobot.model.OutputList;
import com.datarobot.model.PagingParams;
import com.datarobot.model.PredictionList;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class AIClient
implements IAIClient,
IDoGetCallback<AI> {
    private IDataRobotAIClient client;
    private Action<HttpRequest, HttpResponse> httpMessageTransformer = null;

    public AIClient(IDataRobotAIClient client) {
        this.client = client;
    }

    @Override
    public Action<HttpRequest, HttpResponse> getHttpMessageTransformer() {
        return this.httpMessageTransformer;
    }

    @Override
    public void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer) {
        this.httpMessageTransformer = httpMessageTransformer;
    }

    @Override
    public AI get(String id) throws ClientException {
        Argument.IsNotNullOrEmpty(id, "id");
        return this.client.getConnection().get(AI.class, "ais/" + id + "/", null, this.httpMessageTransformer);
    }

    @Override
    public AIList list() throws ClientException {
        return this.list(null);
    }

    @Override
    public AIList list(PagingParams params) throws ClientException {
        Map<String, Object> parameters = null;
        if (params != null) {
            parameters = params.toParameters();
        }
        AIList list = this.client.getConnection().get(AIList.class, "ais/", parameters, this.httpMessageTransformer);
        for (AI ai : list.getItems()) {
            ai.setClient(this.client);
        }
        return list;
    }

    @Override
    public AI createAI(String name) throws ClientException, InterruptedException {
        AICreationResponse aiResponse = this.client.getConnection().post(AICreationResponse.class, "ais/", null, new AIBody(name, 1), this.httpMessageTransformer);
        String aiId = aiResponse.getAIId();
        return this.get(aiId);
    }

    @Override
    public void delete(String aiId) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        this.client.getConnection().delete("/ais/" + aiId + "/", null, this.httpMessageTransformer);
    }

    @Override
    public void addLearningSession(String aiId, String learningSessionId, String outputName) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Argument.IsNotNullOrEmpty(learningSessionId, "learningSessionId");
        Argument.IsNotNullOrEmpty(outputName, "outputName");
        String url = "/ais/" + aiId + "/learningSessions/";
        this.client.getConnection().post(AIEmptyResponse.class, url, null, new AIBody(learningSessionId, outputName), this.httpMessageTransformer);
    }

    @Override
    public void addDataset(String aiId, String datasetId) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Argument.IsNotNullOrEmpty(datasetId, "datasetId");
        String url = "/ais/" + aiId + "/datasets/";
        this.client.getConnection().post(AIEmptyResponse.class, url, null, new AIBody(datasetId, 2), this.httpMessageTransformer);
    }

    @Override
    public LearningSessionList getLearningSessions(String aiId) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        LearningSessionList list = this.client.getConnection().get(LearningSessionList.class, "/learningSessions/", new AIBody(aiId, 3).toParameters(), this.httpMessageTransformer);
        return this.setClient(list);
    }

    @Override
    public LearningSessionList getLearningSessions(String aiId, PagingParams params) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Map<String, Object> parm = params.toParameters();
        parm.put("aiId", aiId);
        LearningSessionList list = this.client.getConnection().get(LearningSessionList.class, "/learningSessions/", parm, this.httpMessageTransformer);
        return this.setClient(list);
    }

    private LearningSessionList setClient(LearningSessionList list) {
        for (LearningSession ls : list.getItems()) {
            ls.setClient(this.client);
        }
        return list;
    }

    @Override
    public Output getOutput(String aiId, String outputTarget) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Argument.IsNotNullOrEmpty(outputTarget, "outputTarget");
        String url = "ais/" + aiId + "/outputs/" + outputTarget;
        Output output = this.client.getConnection().get(Output.class, url, null, this.httpMessageTransformer);
        output.setAiId(aiId);
        return output;
    }

    @Override
    public PredictionList predict(String aiId, String target, String filePath) throws ClientException, FileNotFoundException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Argument.IsNotNullOrEmpty(target, "target");
        Argument.IsNotNullOrEmpty(filePath, "filePath");
        return this.client.predictions().aiPredict(aiId, target, filePath);
    }

    @Override
    public PredictionList infer(String aiId, String target, String filePath) throws ClientException, FileNotFoundException {
        return this.predict(aiId, target, filePath);
    }

    @Override
    public OutputList getOutputs(String aiId) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        String url = "ais/" + aiId + "/outputs/";
        OutputList list = this.client.getConnection().get(OutputList.class, url, null, this.httpMessageTransformer);
        return this.setClientAndAIId(list, aiId);
    }

    @Override
    public OutputList getOutputs(String aiId, PagingParams params) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        String url = "ais/" + aiId + "/outputs/";
        Map<String, Object> parm = params.toParameters();
        OutputList list = this.client.getConnection().get(OutputList.class, url, parm, this.httpMessageTransformer);
        return this.setClientAndAIId(list, aiId);
    }

    private OutputList setClientAndAIId(OutputList list, String aiId) {
        for (Output output : list.getItems()) {
            output.setClient(this.client);
            output.setAiId(aiId);
        }
        return list;
    }

    @Override
    public void addOutput(String aiId, String learningSessionId, String outputName) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Argument.IsNotNullOrEmpty(learningSessionId, "learningSessionId");
        Argument.IsNotNullOrEmpty(outputName, "outputName");
        String url = "ais/" + aiId + "/outputs/";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("learningSessionId", learningSessionId);
        body.put("outputName", outputName);
        this.client.getConnection().put(Output.class, url, null, body, this.httpMessageTransformer);
    }

    @Override
    public OutputFeatures getOutputFeatures(String aiId, String outputName) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, "aiId");
        Argument.IsNotNullOrEmpty(outputName, "outputName");
        String url = "ais/" + aiId + "/outputs/" + outputName + "/features/";
        return this.client.getConnection().get(OutputFeatures.class, url, null, this.httpMessageTransformer);
    }

    public String toString() {
        return "AIClient";
    }
}

