/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.IDatasetClient;
import com.datarobot.impl.Argument;
import com.datarobot.impl.ClientException;
import com.datarobot.impl.StatusTask;
import com.datarobot.model.Dataset;
import com.datarobot.model.DatasetImportResponse;
import com.datarobot.model.DatasetList;
import com.datarobot.model.DatasetStreamSource;
import com.datarobot.model.DatasetUrlSource;
import com.datarobot.model.IDoGetCallback;
import com.datarobot.model.PagingParams;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class DatasetClient
implements IDatasetClient,
IDoGetCallback<Dataset> {
    private IDataRobotAIClient client;
    private Action<HttpRequest, HttpResponse> httpMessageTransformer = null;
    private final ExecutorService pool = Executors.newFixedThreadPool(10);

    public DatasetClient(IDataRobotAIClient client) {
        this.client = client;
    }

    @Override
    public Action<HttpRequest, HttpResponse> getHttpMessageTransformer() {
        return this.httpMessageTransformer;
    }

    @Override
    public void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer) {
        this.httpMessageTransformer = httpMessageTransformer;
    }

    @Override
    public Dataset importFile(String sourceFile) throws ClientException, FileNotFoundException, InterruptedException {
        Argument.IsNotNull(sourceFile, "sourceFile");
        StatusTask<Dataset> task = this.importFileTask(sourceFile);
        return task.getResult();
    }

    @Override
    public Dataset importUrl(String url) throws ClientException, InterruptedException {
        Argument.IsNotNull(url, "URL");
        StatusTask<Dataset> task = this.importURLTask(URI.create(url));
        return task.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusTask<Dataset> importFileTask(String sourceFile) throws ClientException, FileNotFoundException {
        File initialFile = new File(sourceFile);
        FileInputStream inputStream = new FileInputStream(initialFile);
        Path p = Paths.get(sourceFile, new String[0]);
        try {
            StatusTask<Dataset> statusTask = this.importStreamTask(p.getFileName().toString(), inputStream);
            return statusTask;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    private StatusTask<Dataset> importURLTask(URI uri) throws ClientException {
        DatasetUrlSource body = new DatasetUrlSource("Hack", uri);
        DatasetImportResponse urlResponse = this.client.getConnection().post(DatasetImportResponse.class, "datasets/urlImports/", null, body, this.httpMessageTransformer);
        return new StatusTask<Dataset>(this.client, urlResponse, this);
    }

    private StatusTask<Dataset> importStreamTask(String fileName, InputStream stream) throws ClientException {
        DatasetStreamSource streamSource = new DatasetStreamSource(fileName, stream);
        DatasetImportResponse fileResponse = this.client.getConnection().postFile(DatasetImportResponse.class, "datasets/fileImports/", null, streamSource.getName(), streamSource.getStream(), streamSource.getContentType(), this.httpMessageTransformer);
        return new StatusTask<Dataset>(this.client, fileResponse, this);
    }

    @Override
    public Future<Dataset> startImportFile(String fileName) throws ClientException, FileNotFoundException {
        final StatusTask<Dataset> task = this.importFileTask(fileName);
        return this.pool.submit(new Callable<Dataset>(){

            @Override
            public Dataset call() throws ClientException, InterruptedException {
                return (Dataset)task.getResult();
            }
        });
    }

    @Override
    public Future<Dataset> startimportUrl(String url) throws ClientException {
        final StatusTask<Dataset> task = this.importURLTask(URI.create(url));
        return this.pool.submit(new Callable<Dataset>(){

            @Override
            public Dataset call() throws ClientException, InterruptedException {
                return (Dataset)task.getResult();
            }
        });
    }

    @Override
    public DatasetList list() throws ClientException {
        return this.list(new PagingParams(0, 0));
    }

    @Override
    public DatasetList list(PagingParams params) throws ClientException {
        Map<String, Object> parameters = null;
        if (params != null) {
            parameters = params.toParameters();
        }
        DatasetList list = this.client.getConnection().get(DatasetList.class, "datasets/", parameters, this.httpMessageTransformer);
        return this.setClient(list);
    }

    @Override
    public DatasetList list(String aiId) throws ClientException {
        Argument.IsNotNullOrEmpty(aiId, aiId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("aiId", aiId);
        DatasetList list = this.client.getConnection().get(DatasetList.class, "datasets/", parameters, this.httpMessageTransformer);
        return this.setClient(list);
    }

    private DatasetList setClient(DatasetList list) {
        for (Dataset dataset : list.getItems()) {
            dataset.setClient(this.client);
        }
        return list;
    }

    @Override
    public Dataset get(String datasetId) throws ClientException {
        Argument.IsNotNullOrEmpty(datasetId, "datasetId");
        return this.client.getConnection().get(Dataset.class, "datasets/" + datasetId + "/", null, this.httpMessageTransformer);
    }

    @Override
    public void delete(String datasetId) throws ClientException {
        Argument.IsNotNullOrEmpty(datasetId, "datasetId");
        this.client.getConnection().delete("/datasets/" + datasetId + "/", null, this.httpMessageTransformer);
    }

    public String toString() {
        return "DatasetClient";
    }
}

