/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.impl;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.impl.ClientException;
import com.datarobot.model.IDoGetCallback;
import com.datarobot.model.ILocationResponse;
import com.datarobot.model.Status;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatusTask<T> {
    private final int DEFAULT_TIMEOUT = 1800;
    private final int MAX_WAIT = 300;
    private Pattern urlIdPattern = Pattern.compile("/([a-f\\d]{24})/$");
    private IDataRobotAIClient client;
    private IDoGetCallback<T> callback;
    private boolean complete = false;
    private boolean successful = false;
    private boolean didTimeOut = false;
    private T result = null;
    private String error;
    private String status;
    private String message;
    private ILocationResponse hasLocation;
    private final ExecutorService pool = Executors.newFixedThreadPool(10);
    private static final Logger logger = LogManager.getLogger(StatusTask.class);
    private Action<HttpRequest, HttpResponse> httpMessageTransformer = null;

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean getSuccess() {
        return this.successful;
    }

    public String getError() {
        return this.error;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean timeOut() {
        return this.didTimeOut;
    }

    public Action<HttpRequest, HttpResponse> getHttpMessageTransformer() {
        return this.httpMessageTransformer;
    }

    public void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer) {
        this.httpMessageTransformer = httpMessageTransformer;
    }

    public StatusTask(IDataRobotAIClient client, ILocationResponse hasLocation, IDoGetCallback<T> callback) {
        this.client = client;
        this.hasLocation = hasLocation;
        this.callback = callback;
        if (hasLocation.getStatusCode() == 303) {
            this.complete = true;
            this.error = "";
            this.successful = true;
            this.status = "COMPLETE";
            this.message = "";
        } else if (hasLocation.getStatusCode() == 202 || hasLocation.getStatusCode() == 204) {
            this.complete = false;
            this.error = "";
            this.successful = true;
            this.status = "CREATED";
            this.message = "";
        }
    }

    public Future<T> getResultAsync(final int timeout) {
        return this.pool.submit(new Callable<T>(){

            @Override
            public T call() throws ClientException, InterruptedException {
                return StatusTask.this.getResult(timeout);
            }
        });
    }

    public Future<T> getResultAsync() {
        return this.pool.submit(new Callable<T>(){

            @Override
            public T call() throws ClientException, InterruptedException {
                return StatusTask.this.getResult(1800);
            }
        });
    }

    public T getResult() throws ClientException, InterruptedException {
        return this.getResult(1800);
    }

    public T getResult(int timeout) throws ClientException, InterruptedException {
        if (timeout == 0 && !this.complete) {
            this.checkComplete();
        } else {
            int current_timeout = 1800;
            if (timeout != -1) {
                current_timeout = timeout;
            }
            int elapsed = 0;
            double i = 0.0;
            while (true) {
                if (elapsed >= current_timeout) {
                    this.didTimeOut = true;
                    throw new ClientException("Timeout occurred.");
                }
                int wait = new Random().nextInt(Math.min(300, (int)Math.pow(1.5, i)));
                logger.debug("Waiting " + wait + " second(s)...");
                Thread.sleep(wait * 1000);
                if (this.checkComplete()) break;
                i += 1.0;
                elapsed += wait;
            }
        }
        if (this.result != null) {
            return this.result;
        }
        throw new ClientException("Task did not complete successfully.");
    }

    private boolean checkComplete() throws ClientException {
        if (this.complete) {
            return true;
        }
        Status statusObj = this.client.status().get(this.hasLocation.getStatusId());
        if (statusObj.getStatus().equals("COMPLETED")) {
            this.result = this.callback.get(this.stripUrlId(statusObj.getResult().toString()));
            return true;
        }
        this.status = statusObj.getStatus();
        this.message = statusObj.getMessage();
        if (new HashSet<String>(Arrays.asList("ERROR", "ABORT")).contains(statusObj.getStatus())) {
            this.complete = true;
            this.successful = false;
            this.error = statusObj.getMessage();
            logger.error(this.error);
            return true;
        }
        logger.info(this.status + ": " + this.message);
        return false;
    }

    private String stripUrlId(String location) throws ClientException {
        Matcher matchId = this.urlIdPattern.matcher(location);
        if (!matchId.find()) {
            throw new ClientException("Invalid ID in redirect header.");
        }
        return matchId.group(1);
    }

    public String toString() {
        return "StatusTask [client=" + this.client + ", complete=" + this.complete + ", successful=" + this.successful + ", didTimeOut=" + this.didTimeOut + ", status=" + this.status + "]";
    }
}

