/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.model;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.impl.ClientException;
import com.datarobot.model.Dataset;
import com.datarobot.model.DatasetList;
import com.datarobot.model.INeedClient;
import com.datarobot.model.LearningSession;
import com.datarobot.model.LearningSessionList;
import com.datarobot.model.Output;
import com.datarobot.model.OutputList;
import com.datarobot.model.PredictionList;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Map;
import org.joda.time.DateTime;

public class AI
implements Serializable,
INeedClient {
    private static final long serialVersionUID = 4003768784013717195L;
    private String outputListUrl;
    private String datasetListUrl;
    private String learningSessionListUrl;
    @JsonIgnore
    private IDataRobotAIClient client;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="outputCount")
    private int outputCount;
    @JsonProperty(value="datasetCount")
    private int datasetCount;
    @JsonProperty(value="learningSessionCount")
    private int learningSessionCount;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="createdOn")
    private DateTime createdOn;

    @JsonProperty(value="links")
    private void unpack(Map<String, String> links) throws ClientException {
        this.outputListUrl = links.get("outputsList");
        this.datasetListUrl = links.get("datasetsList");
        this.learningSessionListUrl = links.get("learningSessionsList");
    }

    public String getOutputListUrl() {
        return this.outputListUrl;
    }

    public String getDatasetUrl() {
        return this.datasetListUrl;
    }

    public String getLearningSessionUrlList() {
        return this.learningSessionListUrl;
    }

    public String getName() {
        return this.name;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public int getDatasetCount() {
        return this.datasetCount;
    }

    public int getLearningSessionCount() {
        return this.learningSessionCount;
    }

    public String getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        return this.createdOn;
    }

    public void setOutputListUrl(String outputListUrl) {
        this.outputListUrl = outputListUrl;
    }

    public void setDatasetListUrl(String datasetListUrl) {
        this.datasetListUrl = datasetListUrl;
    }

    public void setLearningSessionListUrl(String learningSessionListUrl) {
        this.learningSessionListUrl = learningSessionListUrl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public void setDatasetCount(int datasetCount) {
        this.datasetCount = datasetCount;
    }

    public void setLearningSessionCount(int learningSessionCount) {
        this.learningSessionCount = learningSessionCount;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setClient(IDataRobotAIClient client) {
        this.client = client;
    }

    public Dataset importFile(String filepath) throws FileNotFoundException, ClientException, InterruptedException {
        Dataset data = this.client.data().importFile(filepath);
        this.addDataset(data);
        return data;
    }

    public Dataset importUrl(String url) throws ClientException, InterruptedException {
        Dataset data = this.client.data().importUrl(url);
        this.addDataset(data);
        return data;
    }

    public void addDataset(Dataset dataset) throws ClientException {
        this.client.ais().addDataset(this.id, dataset.getId());
        this.sync();
    }

    public void addLearningSession(LearningSession learningSession) throws ClientException {
        this.client.ais().addLearningSession(this.id, learningSession.getId(), learningSession.getTarget());
        this.sync();
    }

    public AI learn(String target, String sourcefile) throws ClientException, InterruptedException, FileNotFoundException {
        Dataset trainingData = this.importFile(sourcefile);
        LearningSession ls = this.client.learning().learn(trainingData.getId(), target).getResult();
        this.addLearningSession(ls);
        return this;
    }

    public PredictionList predict(String target, String sourceFile) throws FileNotFoundException, ClientException {
        return this.client.predictions().aiPredict(this.id, target, sourceFile);
    }

    public PredictionList infer(String target, String sourceFile) throws FileNotFoundException, ClientException {
        return this.client.predictions().aiPredict(this.id, target, sourceFile);
    }

    public Output getOutput(String outputTarget) throws ClientException {
        return this.client.ais().getOutput(this.id, outputTarget);
    }

    public OutputList getOutputs() throws ClientException {
        return this.client.ais().getOutputs(this.id);
    }

    public void addOutput(String learningSessionId, String outputName) throws ClientException {
        this.client.ais().addOutput(this.id, learningSessionId, outputName);
        this.sync();
    }

    public LearningSessionList getLearningSessions() throws ClientException {
        return this.client.ais().getLearningSessions(this.id);
    }

    public DatasetList getDatasets() throws ClientException {
        return this.client.data().list(this.id);
    }

    public void sync() throws ClientException {
        AI serverData = this.client.ais().get(this.id);
        this.outputCount = serverData.outputCount;
        this.datasetCount = serverData.datasetCount;
        this.learningSessionCount = serverData.learningSessionCount;
        this.name = serverData.name;
    }

    public String toString() {
        return "AI [outputListUrl=" + this.outputListUrl + ", datasetListUrl=" + this.datasetListUrl + ", learningSessionListUrl=" + this.learningSessionListUrl + ", client=" + this.client + ", name=" + this.name + ", outputCount=" + this.outputCount + ", datasetCount=" + this.datasetCount + ", learningSessionCount=" + this.learningSessionCount + ", id=" + this.id + "]";
    }
}

