/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.model;

import com.datarobot.impl.ClientException;
import com.datarobot.model.ILocationResponse;
import com.datarobot.model.ReturnsLocation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonIgnoreProperties(value={"links"})
public class DatasetImportResponse
extends ReturnsLocation
implements ILocationResponse {
    private Pattern currentIdPattern = Pattern.compile("dataset|status/([a-f\\d-]{24,36})/$");
    @JsonProperty(value="statusId")
    private String statusId;
    @JsonProperty(value="datasetId")
    private String datasetId;
    private int statusCode;

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public String getObjectId() {
        return this.getDatasetId();
    }

    @Override
    public void setObjectId(String objectId) {
        this.datasetId = objectId;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusId() {
        return this.statusId;
    }

    @Override
    public void setStatusId() {
    }

    @Override
    void parseIdFromUrl(String location) throws ClientException {
        Matcher matchId = this.currentIdPattern.matcher(location);
        if (!matchId.find()) {
            throw new ClientException("Invalid id in redirect header.");
        }
    }
}

