/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.model;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.impl.ClientException;
import com.datarobot.model.Deployment;
import com.datarobot.model.Evaluation;
import com.datarobot.model.INeedClient;
import com.datarobot.model.LearningSessionFeatures;
import com.datarobot.model.PredictionList;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "datasetId", "name", "target", "created", "evaluation"})
public class LearningSession
implements Serializable,
INeedClient {
    @JsonIgnore
    IDataRobotAIClient client;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="datasetId")
    private String datasetId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="created")
    private DateTime created;
    @JsonProperty(value="modelCount")
    private int modelCount;
    @JsonProperty(value="evaluation")
    private Evaluation evaluation;
    private String result;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = -7584943958576758458L;
    @JsonIgnore
    private Deployment deployment;

    @JsonProperty(value="links")
    private void unpack(Map<String, String> links) throws ClientException {
        if (links.containsKey("result")) {
            this.result = links.get("result");
        }
    }

    @Override
    public void setClient(IDataRobotAIClient client) {
        this.client = client;
    }

    public String getId() {
        return this.id;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    public DateTime getCreatedOn() {
        return this.created;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public Evaluation getEvaluation() throws ClientException {
        return this.evaluation;
    }

    public void refresh() throws ClientException {
        LearningSession ls = this.client.learning().get(this.id);
        this.evaluation = ls.getEvaluation();
        this.modelCount = ls.getModelCount();
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public PredictionList predict(String sourceFile) throws ClientException, FileNotFoundException {
        if (this.client == null) {
            throw new ClientException("The instance of LearningSession must include a reference to the DataRobotAIClient in order to make fit a model. Please include the reference when constructing the object.");
        }
        Deployment deployment = this.client.learning().getDeployment(this.id);
        return this.client.predictions().deploymentPredict(deployment, sourceFile);
    }

    public LearningSessionFeatures getFeatures() throws ClientException {
        if (this.client == null) {
            throw new ClientException("The instance of LearningSession must include a reference to the DataRobotAIClient in order to retrieve features.  Please include the reference when constructing the object.");
        }
        return this.client.learning().getFeatures(this.id);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.datasetId).append((Object)this.name).append((Object)this.target).append((Object)this.created).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LearningSession)) {
            return false;
        }
        LearningSession rhs = (LearningSession)other;
        return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).append((Object)this.datasetId, (Object)rhs.datasetId).append((Object)this.name, (Object)rhs.name).append((Object)this.target, (Object)rhs.target).append((Object)this.created, (Object)rhs.created).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public String toString() {
        return "LearningSession [client=" + this.client + ", id=" + this.id + ", datasetId=" + this.datasetId + ", name=" + this.name + ", target=" + this.target + ", created=" + this.created + ", modelCount=" + this.modelCount + ", evaluation=" + this.evaluation + "]";
    }
}

