/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.model;

import com.datarobot.impl.ClientException;
import com.datarobot.model.ILocationResponse;
import com.datarobot.model.ReturnsLocation;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LearningSessionLearnResponse
extends ReturnsLocation
implements ILocationResponse {
    private Pattern currentIdPattern = Pattern.compile("learningSession|status/([a-f\\d-]{24,36})/$");
    private String statusId;
    private int statusCode;
    private String statusUrl;

    @JsonProperty(value="links")
    private void unpack(Map<String, String> links) throws ClientException {
        this.statusUrl = links.get("result");
        this.statusId = this.parseStatusId(this.statusUrl);
    }

    public String getStatusUrl() {
        return this.statusUrl;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusId() {
        return this.statusId;
    }

    @Override
    public void setStatusId() {
        String statusUrl = this.getStatusUrl();
        try {
            this.parseIdFromUrl(statusUrl);
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    @Override
    void parseIdFromUrl(String statusUrl) throws ClientException {
        Matcher matchId = this.currentIdPattern.matcher(statusUrl);
        if (!matchId.find()) {
            throw new ClientException("Invalid id in redirect header.");
        }
        this.statusId = matchId.group(1);
    }

    @Override
    public String getObjectId() {
        return this.statusId;
    }

    @Override
    public void setObjectId(String objectId) {
    }

    private String parseStatusId(String statusUrl) throws ClientException {
        Matcher matchId = this.currentIdPattern.matcher(statusUrl);
        if (!matchId.find()) {
            throw new ClientException("Invalid id in redirect header.");
        }
        return matchId.group(1);
    }
}

