/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.model;

import com.datarobot.IDataRobotAIClient;
import com.datarobot.impl.ClientException;
import com.datarobot.model.Evaluation;
import com.datarobot.model.INeedClient;
import com.datarobot.model.OutputFeatures;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Output
implements Serializable,
INeedClient {
    private static final long serialVersionUID = -5533037101250361907L;
    private String datarobotKey;
    private String deploymentId;
    private String url;
    private String modelType;
    private Map<String, String> source;
    private String aiId;
    private Evaluation evaluation;
    @JsonIgnore
    private IDataRobotAIClient client;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="createdOn")
    private DateTime createdOn;

    @JsonProperty(value="source")
    private void unpack_source(Map<String, String> source) throws ClientException {
        this.source = source;
        this.datarobotKey = source.get("datarobot-key");
        this.deploymentId = source.get("deploymentId");
        this.url = source.get("url");
        this.modelType = source.get("modelType");
    }

    @JsonProperty(value="evaluation")
    private void unpack_eval(Map<String, Object> eval) throws ClientException {
        this.evaluation = new Evaluation((String)eval.get("summary"), (Double)eval.get("score"), (String)eval.get("label"));
    }

    public String getDataRobotKey() {
        return this.datarobotKey;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    public DateTime getCreatedDate() {
        return this.createdOn;
    }

    public OutputFeatures getFeatures() throws ClientException {
        return this.client.ais().getOutputFeatures(this.aiId, this.target);
    }

    public void setAiId(String id) {
        this.aiId = id;
    }

    @Override
    public void setClient(IDataRobotAIClient client) {
        this.client = client;
    }

    public String toString() {
        return "Output [datarobotKey=" + this.datarobotKey + ", deploymentId=" + this.deploymentId + ", url=" + this.url + ", modelType=" + this.modelType + ", aiId=" + this.aiId + ", client=" + this.client + ", name=" + this.name + ", target=" + this.target + "]";
    }
}

