/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public final class JacksonMapperParser
implements ObjectParser {
    private final ObjectMapper objectMapper;

    public JacksonMapperParser(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    public <T> T parseAndClose(InputStream in, Charset charset, Class<T> dataClass) throws IOException {
        return (T)this.objectMapper.readValue(in, dataClass);
    }

    public Object parseAndClose(InputStream in, Charset charset, Type dataType) throws IOException {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(dataType);
        return this.objectMapper.readValue(in, javaType);
    }

    public <T> T parseAndClose(Reader reader, Class<T> dataClass) throws IOException {
        return (T)this.objectMapper.readValue(reader, dataClass);
    }

    public Object parseAndClose(Reader reader, Type dataType) throws IOException {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(dataType);
        return this.objectMapper.readValue(reader, javaType);
    }
}

