/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.internal;

import com.datarobot.prediction.ClassificationScoreEventInfo;
import com.datarobot.prediction.Event;
import com.datarobot.prediction.ExplanationParams;
import com.datarobot.prediction.IClassificationPredictor;
import com.datarobot.prediction.IPredictorInfo;
import com.datarobot.prediction.MulticlassPredictor;
import com.datarobot.prediction.Row;
import com.datarobot.prediction.Score;
import com.datarobot.prediction.internal.PredictorBase;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;

class ClassificationPredictorImpl
extends PredictorBase<MulticlassPredictor, ClassificationScoreEventInfo>
implements IClassificationPredictor,
Serializable {
    private static final String EXPLANATIONS_METHOD = "scoreClassificationWithExplanations";
    private String[] classLabels;

    ClassificationPredictorImpl(MulticlassPredictor predictor) {
        super(predictor);
    }

    @Override
    public Map<String, Double> score(Map<String, ?> row) {
        try {
            long start = System.nanoTime();
            Row rowToScore = this.extractFeatures(row);
            Map<String, Double> proba = ((MulticlassPredictor)this.predictor).classificationScore(rowToScore);
            Duration duration = Duration.ofNanos(System.nanoTime() - start);
            this.sendScoreInfo(new ScoreEventInfo((IPredictorInfo)this, row, proba, duration));
            return proba;
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Scoring failed", exception);
        }
    }

    @Override
    public Map<String, Double> score(Iterable<?> row) {
        try {
            long start = System.nanoTime();
            Row rowToScore = this.extractFeatures(row);
            Map<String, Double> proba = ((MulticlassPredictor)this.predictor).classificationScore(rowToScore);
            Duration duration = Duration.ofNanos(System.nanoTime() - start);
            if (!this.scoreEvent.getSubscribers().isEmpty()) {
                this.sendScoreInfo(new ScoreEventInfo((IPredictorInfo)this, this.extractFeaturesMap(row), proba, duration));
            }
            return proba;
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Scoring failed", exception);
        }
    }

    @Override
    public Score<Map<String, Double>> scoreWithExplanations(Map<String, ?> row) {
        return this.scoreWithExplanations(row, null);
    }

    @Override
    public Score<Map<String, Double>> scoreWithExplanations(Iterable<?> row) {
        return this.scoreWithExplanations(this.extractFeaturesMap(row), null);
    }

    @Override
    public Score<Map<String, Double>> scoreWithExplanations(Map<String, ?> row, ExplanationParams predictionExplanationParams) {
        if (predictionExplanationParams == null) {
            predictionExplanationParams = this.getDefaultPredictionExplanationParams();
        }
        long start = System.nanoTime();
        Row features = this.extractFeatures(row);
        try {
            Method predictorMethod = this.getPredictorMethod(EXPLANATIONS_METHOD, Row.class, ExplanationParams.class);
            Score score = (Score)predictorMethod.invoke((Object)this.predictor, features, predictionExplanationParams);
            Duration duration = Duration.ofNanos(System.nanoTime() - start);
            if (!this.scoreEvent.getSubscribers().isEmpty()) {
                this.sendScoreInfo(new ScoreEventInfo((IPredictorInfo)this, row, (Map)score.getScore(), duration));
            }
            return score;
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Score<Map<String, Double>> scoreWithExplanations(Iterable<?> row, ExplanationParams predictionExplanationParams) {
        return this.scoreWithExplanations(this.extractFeaturesMap(row), predictionExplanationParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getClassLabels() {
        if (null == this.classLabels) {
            ClassificationPredictorImpl classificationPredictorImpl = this;
            synchronized (classificationPredictorImpl) {
                if (null == this.classLabels) {
                    this.classLabels = this.retrieveClassLabels();
                }
            }
        }
        return this.classLabels;
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    @Override
    public LinkedHashMap<String, Class> getFeatures() {
        return this.features;
    }

    @Override
    public Class<?> getPredictorClass() {
        return IClassificationPredictor.class;
    }

    @Override
    public ExplanationParams getDefaultPredictionExplanationParams() {
        return super.getDefaultParams();
    }

    @Override
    public Map<String, String> getModelInfo() {
        return this.modelInfo;
    }

    private String[] retrieveClassLabels() {
        try {
            Field classLabelsField = this.getField(((MulticlassPredictor)this.predictor).getClass(), "classLabels");
            if (classLabelsField == null) {
                throw new UnsupportedOperationException("Class labels not available.");
            }
            classLabelsField.setAccessible(true);
            return (String[])classLabelsField.get(this.predictor);
        }
        catch (IllegalAccessException illegalAccessError) {
            throw new UnsupportedOperationException("Class labels not available.");
        }
    }

    @Override
    public Event<ClassificationScoreEventInfo> getScoreEvent() {
        return this.scoreEvent;
    }

    private static class ScoreEventInfo
    extends PredictorBase.ScoreEventInfoBase<Map<String, ?>, Map<String, Double>>
    implements ClassificationScoreEventInfo {
        ScoreEventInfo(IPredictorInfo sender, Map<String, ?> input, Map<String, Double> output, Duration duration) {
            super(sender, input, output, duration);
        }

        @Override
        public Map<String, ?> getInput() {
            return (Map)this.input;
        }

        @Override
        public Map<String, Double> getOutput() {
            return (Map)this.output;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public IPredictorInfo getSender() {
            return this.sender;
        }
    }
}

