/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.internal;

import com.datarobot.prediction.Event;
import com.datarobot.prediction.ExplanationParams;
import com.datarobot.prediction.IPredictorInfo;
import com.datarobot.prediction.ITimeSeriesRegressionPredictor;
import com.datarobot.prediction.TimeSeriesOptions;
import com.datarobot.prediction.TimeSeriesPredictor;
import com.datarobot.prediction.TimeSeriesRegressionScoreEventInfo;
import com.datarobot.prediction.TimeSeriesScore;
import com.datarobot.prediction.internal.PredictorBase;
import com.datarobot.prediction.internal.TimeSeriesBase;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TimeSeriesRegressionPredictorImpl
extends TimeSeriesBase
implements ITimeSeriesRegressionPredictor {
    protected TimeSeriesRegressionPredictorImpl(TimeSeriesPredictor predictor) {
        super(predictor);
    }

    @Override
    public List<TimeSeriesScore<Double>> score(ArrayList<Map<String, ?>> rows) {
        TimeSeriesOptions options = new TimeSeriesOptions.Builder().buildSingleForecastPointRequest();
        return this.score(rows, options);
    }

    @Override
    public List<TimeSeriesScore<Double>> score(ArrayList<Map<String, ?>> rows, String forecastPoint) {
        TimeSeriesOptions options = new TimeSeriesOptions.Builder().buildSingleForecastPointRequest(forecastPoint);
        return this.score(rows, options);
    }

    @Override
    public List<TimeSeriesScore<Double>> score(ArrayList<Map<String, ?>> rows, String startDate, String endDate) {
        TimeSeriesOptions options = new TimeSeriesOptions.Builder().buildForecastDateRangeRequest(startDate, endDate);
        return this.score(rows, options);
    }

    @Override
    public List<TimeSeriesScore<Double>> score(ArrayList<Map<String, ?>> rows, TimeSeriesOptions options) {
        long start = System.nanoTime();
        List<TimeSeriesScore<Double>> score = ((TimeSeriesPredictor)this.predictor).score(this.extractRows(rows), options);
        Duration duration = Duration.ofNanos(System.nanoTime() - start);
        this.sendScoreInfo(new ScoreEventInfo(this, rows, score, options, duration));
        return score;
    }

    @Override
    public String getSeriesIdColumnName() {
        return this.seriesIdColumnName;
    }

    @Override
    public String getDateColumnName() {
        return this.dateColumnName;
    }

    @Override
    public Map.Entry<Integer, String> getTimeStep() {
        return this.timeStep;
    }

    @Override
    public Map.Entry<Integer, Integer> getFeatureDerivationWindow() {
        return this.fdw;
    }

    @Override
    public Map.Entry<Integer, Integer> getForecastWindow() {
        return this.fw;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    @Override
    public LinkedHashMap<String, Class> getFeatures() {
        return this.features;
    }

    @Override
    public Class<?> getPredictorClass() {
        return ITimeSeriesRegressionPredictor.class;
    }

    @Override
    public ExplanationParams getDefaultPredictionExplanationParams() {
        return this.getDefaultParams();
    }

    @Override
    public Map<String, String> getModelInfo() {
        return this.modelInfo;
    }

    @Override
    public Event<TimeSeriesRegressionScoreEventInfo> getScoreEvent() {
        return this.scoreEvent;
    }

    private static class ScoreEventInfo
    extends PredictorBase.EventInfoBase
    implements TimeSeriesRegressionScoreEventInfo {
        private final ArrayList<Map<String, ?>> inputs;
        private final List<TimeSeriesScore<Double>> outputs;
        private final TimeSeriesOptions options;
        private final Duration duration;

        ScoreEventInfo(IPredictorInfo sender, ArrayList<Map<String, ?>> inputs, List<TimeSeriesScore<Double>> outputs, TimeSeriesOptions options, Duration duration) {
            super(sender);
            this.inputs = inputs;
            this.outputs = outputs;
            this.options = options;
            this.duration = duration;
        }

        @Override
        public ArrayList<Map<String, ?>> getInput() {
            return this.inputs;
        }

        @Override
        public List<TimeSeriesScore<Double>> getOutput() {
            return this.outputs;
        }

        @Override
        public TimeSeriesOptions getInferenceOptions() {
            return this.options;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        public IPredictorInfo getSender() {
            return this.sender;
        }
    }
}

