/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.transform.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class InputUtils {
    private static final String[] NULL_VALUES = new String[]{"null", "na", "n/a", "#N/A", "N/A", "?", ".", "Inf", "INF", "inf", "-inf", "-Inf", "-INF", "-1.#IND", "1.#QNAN", "1.#IND", "-1.#QNAN", "#N/A N/A", "NA", "#NA", "NULL", "NaN", "nan", " ", "None"};
    private static final Set<String> NULL_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(NULL_VALUES)));
    private static final Pattern INVALID_COLUMN_PATTERN = Pattern.compile("[\\-$.{}\"\n\r]");
    private static final String EMPTY_COLUMN_NAME = "_blank";

    public static boolean isNull(String v) {
        return NULL_SET.contains(v);
    }

    public static double stringToDouble(String v) {
        return InputUtils.stringToDouble(v, Double.NaN);
    }

    public static double stringToDouble(String v, double replacement) {
        if (v == null || v.isEmpty() || InputUtils.isNull(v)) {
            return replacement;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return replacement;
        }
    }

    public static String getSanitizedColumnName(String name) {
        if (name.isEmpty()) {
            return EMPTY_COLUMN_NAME;
        }
        return INVALID_COLUMN_PATTERN.matcher(name).replaceAll("_").trim();
    }

    public static String[] getDRColumnNames(String[] columns) {
        ArrayList<String> drColumnNames = new ArrayList<String>();
        HashSet<String> usedColumnNames = new HashSet<String>(Arrays.asList(columns));
        for (String c : columns) {
            String sanitized = InputUtils.getSanitizedColumnName(c);
            if (!sanitized.equals(c) && usedColumnNames.contains(sanitized)) {
                int collisionId = 0;
                String resolvePrefix = sanitized;
                if (resolvePrefix.charAt(resolvePrefix.length() - 1) != '_') {
                    resolvePrefix = resolvePrefix + "_";
                }
                while (usedColumnNames.contains(resolvePrefix + ++collisionId)) {
                    sanitized = resolvePrefix + collisionId;
                }
            }
            usedColumnNames.add(sanitized);
            drColumnNames.add(sanitized);
        }
        return drColumnNames.toArray(new String[0]);
    }
}

