/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction;

import com.datarobot.prediction.IPredictorInfo;
import com.datarobot.prediction.MulticlassPredictor;
import com.datarobot.prediction.Predictor;
import com.datarobot.prediction.TimeSeriesPredictor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class Predictors {
    private Predictors() {
    }

    public static <T extends IPredictorInfo> T getPredictor() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Predictors.getPredictor(classLoader);
    }

    public static <T extends IPredictorInfo> T getPredictor(ClassLoader classLoader) {
        Iterator<IPredictorInfo> allPredictors = Predictors.getAllPredictors(classLoader);
        if (!allPredictors.hasNext()) {
            throw new UnsupportedOperationException("Could not find any DataRobot models in the classpath.");
        }
        IPredictorInfo predictor = allPredictors.next();
        if (allPredictors.hasNext()) {
            throw new UnsupportedOperationException("More than one DataRobot model detected. Please specify the model id using Predictors.getPredictor(String modelId)");
        }
        return (T)predictor;
    }

    public static <T extends IPredictorInfo> T getPredictor(String modelId) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Predictors.getPredictor(modelId, classLoader);
    }

    public static <T extends IPredictorInfo> T getPredictor(String modelId, ClassLoader classLoader) {
        Iterator<IPredictorInfo> allPredictors = Predictors.getAllPredictors(classLoader);
        while (allPredictors.hasNext()) {
            IPredictorInfo current = allPredictors.next();
            if (!current.getModelId().equals(modelId)) continue;
            return (T)current;
        }
        throw new IllegalArgumentException("Could not load model " + modelId + ". Make sure you added .jar file with the model to the classpath. This issue may also happen if you are trying to use old DataRobot model. In this case, use Predictors class from com.datarobot.prediction.compatible package to load your model.");
    }

    public static Iterator<IPredictorInfo> getAllPredictors() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Predictors.getAllPredictors(loader);
    }

    public static <T extends IPredictorInfo> T getPredictorFromJarFile(String jarPath, String modelId) {
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(jarPath).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
            return Predictors.getPredictor(modelId, classLoader);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Please check the path to jar file", e);
        }
    }

    public static <T extends IPredictorInfo> T getPredictorFromJarFile(String jarPath) {
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(jarPath).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
            return Predictors.getPredictor(classLoader);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Please check the path to jar file", e);
        }
    }

    public static Iterator<IPredictorInfo> getAllPredictorsFromJarFile(String jarPath) {
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(jarPath).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
            return Predictors.getAllPredictors(classLoader);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Please check the path to jar file", e);
        }
    }

    public static Iterator<IPredictorInfo> getAllPredictors(ClassLoader classLoader) {
        Iterator<IPredictorInfo> result = Predictors.wrapPredictors(Predictors.load(Predictor.class, classLoader), Predictor.class, "RegressionPredictorImpl", classLoader);
        result = Predictors.generateFlatIterator(result, Predictors.wrapPredictors(Predictors.load(MulticlassPredictor.class, classLoader), MulticlassPredictor.class, "ClassificationPredictorImpl", classLoader));
        result = Predictors.generateFlatIterator(result, Predictors.wrapPredictors(Predictors.load(TimeSeriesPredictor.class, classLoader), TimeSeriesPredictor.class, "TimeSeriesRegressionPredictorImpl", classLoader));
        return result;
    }

    private static <T extends Predictor> Iterator<IPredictorInfo> wrapPredictors(final Iterator<T> regressionPredictors, final Class<T> oldInterface, final String wrapperName, final ClassLoader classLoader) {
        return new Iterator<IPredictorInfo>(){

            @Override
            public boolean hasNext() {
                return regressionPredictors.hasNext();
            }

            @Override
            public IPredictorInfo next() {
                return Predictors.wrapOldInterface((Predictor)regressionPredictors.next(), oldInterface, wrapperName, classLoader);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This operation is not allowed");
            }
        };
    }

    private static <T> Iterator<T> load(Class<T> clazz, ClassLoader classLoader) {
        return ServiceLoader.load(clazz, classLoader).iterator();
    }

    private static Iterator<IPredictorInfo> generateFlatIterator(final Iterator<IPredictorInfo> firstIterator, final Iterator<IPredictorInfo> secondIterator) {
        return new Iterator<IPredictorInfo>(){

            @Override
            public boolean hasNext() {
                return firstIterator.hasNext() || secondIterator.hasNext();
            }

            @Override
            public IPredictorInfo next() {
                if (firstIterator.hasNext()) {
                    return (IPredictorInfo)firstIterator.next();
                }
                return (IPredictorInfo)secondIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This operation is not allowed");
            }
        };
    }

    private static <OldT extends Predictor> IPredictorInfo wrapOldInterface(OldT old, Class<OldT> oldPredictorClass, String wrapperName, ClassLoader classLoader) {
        try {
            String packageName = old.getClass().getPackage().getName();
            String className = String.format("%s.%s", packageName, wrapperName);
            Class<?> clazz = Class.forName(className, true, classLoader);
            Constructor<?> classificationConstructor = clazz.getDeclaredConstructor(oldPredictorClass);
            classificationConstructor.setAccessible(true);
            return (IPredictorInfo)classificationConstructor.newInstance(oldPredictorClass.cast(old));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not instantiate prediction model. This issue may also happen if you are trying to use old DataRobot model. In this case, use Predictors class from com.datarobot.prediction.compatible package to load your model.)", exception);
        }
    }

    public static class Constants {
        public static final String MODEL_ID = "Model-ID";
        public static final String PROJECT_ID = "Project-ID";
        public static final String PROJECT_NAME = "Project-Name";
        public static final String TARGET = "Target-Name";
        public static final String OFFSET = "Offset";
        public static final String EXPOSURE = "Exposure";
        public static final String FEATURE_LISTS = "Feature-Lists";
        public static final String MODEL_TYPE = "Model-Type";
        public static final String PROJECT_CREATION_TIME = "Project-Creation-Time";
        public static final String DATASET_NAME = "Dataset-Name";
        public static final String TRAINING_SET_PERCENTAGE = "Training-Set-Percentage";
        public static final String MODEL_NAME = "Model-Name";
        public static final String POSITIVE_CLASS = "Positive-Class";
        public static final String NEGATIVE_CLASS = "Negative-Class";
        public static final String CLASS_LABELS = "Class-Labels";
        public static final String DATE_FORMAT = "Date-Format";
        public static final String TIME_STEP = "Time-Step";
        public static final String DATE_INDEX_FIELD = "Date-Index-Field";
        public static final String FDW = "Feature-Derivation-Window";
        public static final String FW = "Forecast-Window";
        public static final String SERIES_ID_COLUMN = "Series-ID-Column";
        public static final String IS_TIME_SERIES = "Is-Time-Series";
        public static final String METRIC = "Metric";
    }
}

