/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction;

import com.datarobot.prediction.ExplanationParams;
import java.io.Serializable;

public class TimeSeriesOptions
implements Serializable {
    public static Integer DEFAULT_PREDICTION_INTERVAL_LENGTH = 80;
    private final String forecastPoint;
    private final String predictionStartDate;
    private final String predictionEndDate;
    private final ExplanationParams explanationParams;
    private final Integer predictionIntervalLength;
    private final boolean isSingleForecastPointRequest;
    private final boolean computeExplanations;
    private final boolean computeIntervals;

    private TimeSeriesOptions(String forecastPoint, String predictionStartDate, String predictionEndDate, ExplanationParams explanationParams, Integer predictionIntervalLength, boolean isSingleForecastPointRequest, boolean computeExplanations, boolean computeIntervals) {
        this.forecastPoint = forecastPoint;
        this.predictionStartDate = predictionStartDate;
        this.predictionEndDate = predictionEndDate;
        this.explanationParams = explanationParams;
        this.predictionIntervalLength = predictionIntervalLength;
        this.isSingleForecastPointRequest = isSingleForecastPointRequest;
        this.computeExplanations = computeExplanations;
        this.computeIntervals = computeIntervals;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getForecastPoint() {
        return this.forecastPoint;
    }

    public String getPredictionStartDate() {
        return this.predictionStartDate;
    }

    public String getPredictionEndDate() {
        return this.predictionEndDate;
    }

    public boolean isSingleForecastPointRequest() {
        return this.isSingleForecastPointRequest;
    }

    public boolean isHistoricalPredictions() {
        return !this.isSingleForecastPointRequest;
    }

    public ExplanationParams getExplanationParams() {
        return this.explanationParams;
    }

    public Integer getPredictionIntervalLength() {
        return this.predictionIntervalLength;
    }

    public boolean isComputeExplanations() {
        return this.computeExplanations;
    }

    public boolean isComputeIntervals() {
        return this.computeIntervals;
    }

    public static class Builder {
        private String forecastPoint;
        private String predictionStartDate;
        private String predictionEndDate;
        private ExplanationParams explanationParams;
        private Integer predictionIntervalLength;
        private boolean isSingleForecastPointRequest = true;
        private boolean computeExplanations;
        private boolean computeIntervals;

        public Builder setExplanationsParams(ExplanationParams explanationParams) {
            this.explanationParams = explanationParams;
            this.computeExplanations = true;
            return this;
        }

        public Builder computeExplanations(boolean computeExplanations) {
            this.computeExplanations = computeExplanations;
            return this;
        }

        public Builder computeIntervals(boolean computeIntervals) {
            this.computeIntervals = computeIntervals;
            return this;
        }

        public Builder setPredictionIntervalLength(Integer predictionIntervalLength) {
            this.predictionIntervalLength = predictionIntervalLength;
            this.computeIntervals = true;
            return this;
        }

        public TimeSeriesOptions buildSingleForecastPointRequest() {
            this.isSingleForecastPointRequest = true;
            return this.build();
        }

        public TimeSeriesOptions buildSingleForecastPointRequest(String forecastPoint) {
            this.forecastPoint = forecastPoint;
            this.isSingleForecastPointRequest = true;
            return this.build();
        }

        public TimeSeriesOptions buildForecastDateRangeRequest() {
            this.isSingleForecastPointRequest = false;
            return this.build();
        }

        public TimeSeriesOptions buildForecastDateRangeRequest(String predictionStartDate, String predictionEndDate) {
            this.predictionStartDate = predictionStartDate;
            this.predictionEndDate = predictionEndDate;
            this.isSingleForecastPointRequest = false;
            return this.build();
        }

        TimeSeriesOptions build() {
            Integer predictionIntervalLength = this.predictionIntervalLength;
            if (this.computeIntervals && predictionIntervalLength == null) {
                predictionIntervalLength = DEFAULT_PREDICTION_INTERVAL_LENGTH;
            }
            if (!this.computeIntervals && predictionIntervalLength != null) {
                predictionIntervalLength = null;
            }
            ExplanationParams explanationParams = this.explanationParams;
            if (!this.computeExplanations && explanationParams != null) {
                explanationParams = null;
            }
            return new TimeSeriesOptions(this.forecastPoint, this.predictionStartDate, this.predictionEndDate, explanationParams, predictionIntervalLength, this.isSingleForecastPointRequest, this.computeExplanations, this.computeIntervals);
        }
    }
}

