/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.compatible;

import com.datarobot.prediction.MulticlassPredictor;
import com.datarobot.prediction.Row;
import com.datarobot.prediction.compatible.IClassificationPredictor;
import com.datarobot.prediction.compatible.PredictorBase;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

class ClassificationPredictorImpl
extends PredictorBase<MulticlassPredictor>
implements IClassificationPredictor,
Serializable {
    private volatile String[] classLabels;

    ClassificationPredictorImpl(MulticlassPredictor predictor) {
        super(predictor);
    }

    @Override
    public Map<String, Double> score(Map<String, ?> row) {
        Row rowToScore = this.extractFeatures(row);
        try {
            return ((MulticlassPredictor)this.predictor).classificationScore(rowToScore);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Scoring failed", exception);
        }
    }

    @Override
    public Map<String, Double> score(Iterable<?> row) {
        Row rowToScore = this.extractFeatures(row);
        try {
            return ((MulticlassPredictor)this.predictor).classificationScore(rowToScore);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Scoring failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getClassLabels() {
        if (null == this.classLabels) {
            ClassificationPredictorImpl classificationPredictorImpl = this;
            synchronized (classificationPredictorImpl) {
                if (null == this.classLabels) {
                    this.classLabels = this.retrieveClassLabels();
                }
            }
        }
        return this.classLabels;
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    @Override
    public LinkedHashMap<String, Class> getFeatures() {
        return this.features;
    }

    @Override
    public Class<?> getPredictorClass() {
        return IClassificationPredictor.class;
    }

    private String[] retrieveClassLabels() {
        try {
            Field classLabelsField = this.getField(((MulticlassPredictor)this.predictor).getClass(), "classLabels");
            if (classLabelsField == null) {
                throw new UnsupportedOperationException("Class labels not available.");
            }
            classLabelsField.setAccessible(true);
            return (String[])classLabelsField.get(this.predictor);
        }
        catch (IllegalAccessException illegalAccessError) {
            throw new UnsupportedOperationException("Class labels not available.");
        }
    }
}

