/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.compatible;

import com.datarobot.prediction.MulticlassPredictor;
import com.datarobot.prediction.Predictor;
import com.datarobot.prediction.compatible.ClassificationPredictorImpl;
import com.datarobot.prediction.compatible.IClassificationPredictor;
import com.datarobot.prediction.compatible.IPredictorInfo;
import com.datarobot.prediction.compatible.IRegressionPredictor;
import com.datarobot.prediction.compatible.RegressionPredictorImpl;
import java.util.Iterator;
import java.util.ServiceLoader;

public class Predictors {
    public static <T extends IPredictorInfo> T getPredictor() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Predictors.getPredictor(classLoader);
    }

    public static <T extends IPredictorInfo> T getPredictor(ClassLoader classLoader) {
        Iterator<IPredictorInfo> allPredictors = Predictors.getAllPredictors(classLoader);
        if (!allPredictors.hasNext()) {
            throw new UnsupportedOperationException("Could not find any DataRobot models in the classpath.");
        }
        IPredictorInfo predictor = allPredictors.next();
        if (allPredictors.hasNext()) {
            throw new UnsupportedOperationException("More than one DataRobot model detected. Please specify the model id using Predictors.getPredictor(String modelId)");
        }
        return (T)predictor;
    }

    public static <T extends IPredictorInfo> T getPredictor(String modelId) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Predictors.getPredictor(modelId, classLoader);
    }

    public static <T extends IPredictorInfo> T getPredictor(String modelId, ClassLoader classLoader) {
        try {
            Class<?> modelClass = Class.forName(String.format("com.datarobot.prediction.dr%s.DRModel", modelId), true, classLoader);
            return (T)Predictors.wrapOldInterface(modelClass.newInstance());
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Cannot find a predictor with the " + modelId + " ID.");
        }
        catch (Exception instantiationException) {
            throw new UnsupportedOperationException("Model with model id=[" + modelId + "] could not be instantiated");
        }
    }

    public static Iterator<IPredictorInfo> getAllPredictors() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Predictors.getAllPredictors(loader);
    }

    public static Iterator<IPredictorInfo> getAllPredictors(ClassLoader classLoader) {
        return Predictors.generateFlatIterator(Predictors.wrapRegressionPredictors(Predictors.load(Predictor.class, classLoader)), Predictors.wrapClassificationPredictors(Predictors.load(MulticlassPredictor.class, classLoader)));
    }

    private static Iterator<IClassificationPredictor> wrapClassificationPredictors(final Iterator<MulticlassPredictor> multiclassPredictors) {
        return new Iterator<IClassificationPredictor>(){

            @Override
            public boolean hasNext() {
                return multiclassPredictors.hasNext();
            }

            @Override
            public IClassificationPredictor next() {
                return (IClassificationPredictor)Predictors.wrapOldInterface(multiclassPredictors.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This operation is not allowed");
            }
        };
    }

    private static Iterator<IRegressionPredictor> wrapRegressionPredictors(final Iterator<Predictor> regressionPredictors) {
        return new Iterator<IRegressionPredictor>(){

            @Override
            public boolean hasNext() {
                return regressionPredictors.hasNext();
            }

            @Override
            public IRegressionPredictor next() {
                return (IRegressionPredictor)Predictors.wrapOldInterface(regressionPredictors.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This operation is not allowed");
            }
        };
    }

    private static <T> Iterator<T> load(Class<T> clazz, ClassLoader classLoader) {
        return ServiceLoader.load(clazz, classLoader).iterator();
    }

    private static Iterator<IPredictorInfo> generateFlatIterator(final Iterator<IRegressionPredictor> firstIterator, final Iterator<IClassificationPredictor> secondIterator) {
        return new Iterator<IPredictorInfo>(){

            @Override
            public boolean hasNext() {
                return firstIterator.hasNext() || secondIterator.hasNext();
            }

            @Override
            public IPredictorInfo next() {
                if (firstIterator.hasNext()) {
                    return (IPredictorInfo)firstIterator.next();
                }
                return (IPredictorInfo)secondIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This operation is not allowed");
            }
        };
    }

    private static <NewT extends IPredictorInfo> NewT wrapOldInterface(Object old) {
        if (old instanceof MulticlassPredictor) {
            return (NewT)new ClassificationPredictorImpl((MulticlassPredictor)old);
        }
        return (NewT)new RegressionPredictorImpl((Predictor)old);
    }
}

