/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.internal;

import com.datarobot.prediction.Row;
import com.datarobot.transform.util.InputUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FeatureExtractor
implements Serializable {
    private static final String DEFAULT_EMPTY_COLUMN_NAME = "_blank";
    private static final String[] DEFAULT_NULL_VALUES = new String[]{"null", "na", "n/a", "#N/A", "N/A", "?", ".", "Inf", "INF", "inf", "-inf", "-Inf", "-INF", "-1.#IND", "1.#QNAN", "1.#IND", "-1.#QNAN", "#N/A N/A", "NA", "#NA", "NULL", "NaN", "nan", " ", "None"};
    private static final Set<String> DEFAULT_NULL_SET = new HashSet<String>(Arrays.asList(DEFAULT_NULL_VALUES));
    private final String[] doublePredictors;
    private final String[] stringPredictors;
    private boolean parseInfAsNull;
    protected int numDoubles;
    protected int numStrings;
    protected LinkedHashMap<String, Class> features;
    protected Map<String, Integer> featuresIndexes;
    protected ConcurrentHashMap<String, String> sanitizedFeaturesCache;

    public FeatureExtractor(String[] doublePredictors, String[] stringPredictors) {
        this(doublePredictors, stringPredictors, true);
    }

    public FeatureExtractor(String[] doublePredictors, String[] stringPredictors, boolean parseInfAsNull) {
        this.doublePredictors = doublePredictors;
        this.stringPredictors = stringPredictors;
        this.parseInfAsNull = parseInfAsNull;
        this.numDoubles = doublePredictors.length;
        this.numStrings = stringPredictors.length;
        this.features = new LinkedHashMap();
        this.featuresIndexes = new HashMap<String, Integer>();
        int featureIndex = 0;
        for (String feature : doublePredictors) {
            this.features.put(feature, Double.class);
            this.featuresIndexes.put(feature, featureIndex);
            ++featureIndex;
        }
        for (String feature : stringPredictors) {
            this.features.put(feature, String.class);
            this.featuresIndexes.put(feature, featureIndex);
            ++featureIndex;
        }
        this.sanitizedFeaturesCache = new ConcurrentHashMap();
    }

    public LinkedHashMap<String, Class> getFeatures() {
        return this.features;
    }

    public Row extractFeatures(Map<String, ?> row) {
        return this.extractFeatures(row, true);
    }

    public Row extractFeaturesWithoutSanitize(Map<String, ?> row) {
        return this.extractFeatures(row, false);
    }

    public Row extractFeatures(Iterable<?> row) {
        double[] doubleFeatures = new double[this.numDoubles];
        String[] stringFeatures = new String[this.numStrings];
        int featureIndex = 0;
        for (Object feature : row) {
            String featureName;
            if (featureIndex < this.numDoubles) {
                featureName = this.doublePredictors[featureIndex];
                doubleFeatures[featureIndex] = this.getDoubleValue(featureName, feature);
            } else {
                featureName = this.stringPredictors[featureIndex - this.numDoubles];
                if (feature != null && !(feature instanceof String)) {
                    throw new IllegalArgumentException("Feature [" + featureName + "] expected to be String, while received value of type[" + feature.getClass().getName() + "]");
                }
                stringFeatures[featureIndex - this.numDoubles] = feature != null ? (String)feature : "";
            }
            ++featureIndex;
        }
        if (featureIndex < this.features.size()) {
            throw new IllegalArgumentException("Some feature values are missing.");
        }
        Row result = new Row();
        result.d = doubleFeatures;
        result.s = stringFeatures;
        return result;
    }

    public Map<String, ?> extractFeaturesMap(Iterable<?> row) {
        Iterator<String> featureNames = this.features.keySet().iterator();
        Iterator<?> featureValues = row.iterator();
        HashMap result = new HashMap();
        while (featureNames.hasNext() && featureValues.hasNext()) {
            result.put(featureNames.next(), featureValues.next());
        }
        return result;
    }

    private Row extractFeatures(Map<String, ?> row, boolean sanitize) {
        double[] doubleFeatures = new double[this.numDoubles];
        String[] stringFeatures = new String[this.numStrings];
        HashSet<String> featuresMissing = new HashSet<String>(this.features.keySet());
        HashMap<String, String> featuresMapping = new HashMap<String, String>();
        for (String feature : row.keySet()) {
            String sanitizedFeature = sanitize ? this.sanitize(feature) : feature;
            if (!this.features.containsKey(sanitizedFeature)) continue;
            if (featuresMapping.containsKey(sanitizedFeature)) {
                throw new IllegalArgumentException("Feature=[" + feature + "] conflicts with name=[" + (String)featuresMapping.get(sanitizedFeature) + "], as both pre-processed to [" + sanitizedFeature + "].");
            }
            featuresMapping.put(sanitizedFeature, feature);
            featuresMissing.remove(sanitizedFeature);
            int featureIndex = this.featuresIndexes.get(sanitizedFeature);
            Object inputValue = row.get(feature);
            if (featureIndex < this.numDoubles) {
                doubleFeatures[featureIndex] = this.getDoubleValue(sanitizedFeature, inputValue);
                continue;
            }
            if (inputValue != null && !(inputValue instanceof String)) {
                throw new IllegalArgumentException("Feature [" + sanitizedFeature + "] expected to be String, while received value of type [" + inputValue.getClass().getName() + "]");
            }
            stringFeatures[featureIndex - this.numDoubles] = inputValue != null ? (String)inputValue : "";
        }
        if (!featuresMissing.isEmpty()) {
            int minNumberToReport = 5;
            int maxIndex = Math.min(minNumberToReport, featuresMissing.size());
            Iterator featuresMissingIterator = featuresMissing.iterator();
            StringBuilder sb = new StringBuilder("Could not find values of the features [");
            for (int sequenceIndex = 0; sequenceIndex < maxIndex; ++sequenceIndex) {
                sb.append((String)featuresMissingIterator.next());
                if (sequenceIndex >= maxIndex - 1) continue;
                sb.append(",");
            }
            sb.append("].");
            throw new IllegalArgumentException(sb.toString());
        }
        Row result = new Row();
        result.d = doubleFeatures;
        result.s = stringFeatures;
        return result;
    }

    protected String sanitize(String name) {
        if (name.isEmpty()) {
            return this.getDefaultEmptyColumnName();
        }
        if (this.sanitizedFeaturesCache.containsKey(name)) {
            return this.sanitizedFeaturesCache.get(name);
        }
        String sanitizedName = InputUtils.getSanitizedColumnName(name);
        this.sanitizedFeaturesCache.putIfAbsent(name, sanitizedName);
        return sanitizedName;
    }

    protected Double getDoubleValue(String featureName, Object value) {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            if (!this.parseInfAsNull) {
                if (((String)value).equalsIgnoreCase("inf")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (((String)value).equalsIgnoreCase("-inf")) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            if (((String)value).isEmpty() || this.getDoubleMissingValuesLabels().contains(value)) {
                return Double.NaN;
            }
            if ("true".equalsIgnoreCase((String)value)) {
                return 1.0;
            }
            if ("false".equalsIgnoreCase((String)value)) {
                return 0.0;
            }
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException exception) {
                return Double.NaN;
            }
        }
        throw new IllegalArgumentException("Feature [" + featureName + "] should be a number while value=[" + value + "] of type=[" + value.getClass() + "] was received.");
    }

    protected String getDefaultEmptyColumnName() {
        return DEFAULT_EMPTY_COLUMN_NAME;
    }

    protected Set<String> getDoubleMissingValuesLabels() {
        return DEFAULT_NULL_SET;
    }
}

