/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.internal;

import com.datarobot.prediction.Event;
import com.datarobot.prediction.EventHandler;
import com.datarobot.prediction.EventInfo;
import com.datarobot.prediction.ExplanationParams;
import com.datarobot.prediction.IPredictorInfo;
import com.datarobot.prediction.Predictor;
import com.datarobot.prediction.Row;
import com.datarobot.prediction.internal.FeatureExtractor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

abstract class PredictorBase<PredictorT extends Predictor, ScoreEventT extends EventInfo>
implements Serializable {
    private static final String EXPLANATION_UTIL_CLASS_NAME = "com.datarobot.prediction.ExplanationUtil";
    PredictorT predictor;
    protected Map<String, String> modelInfo;
    protected String modelId;
    protected String targetName;
    protected final GenericEvent<ScoreEventT> scoreEvent;
    private final FeatureExtractor featureExtractor;

    protected PredictorBase(PredictorT predictor) {
        this.predictor = predictor;
        this.featureExtractor = new FeatureExtractor(predictor.get_double_predictors(), predictor.get_string_predictors());
        this.modelInfo = this.initializeModelInfo(predictor);
        if (this.modelInfo != null && this.modelInfo.containsKey("Model-ID")) {
            this.modelId = this.modelInfo.get("Model-ID");
        } else {
            String[] directories = predictor.getClass().getPackage().getName().split("[.]");
            this.modelId = directories[directories.length - 1].substring(2);
        }
        this.targetName = null;
        if (this.modelInfo != null && this.modelInfo.containsKey("Target-Name")) {
            this.targetName = this.modelInfo.get("Target-Name");
        }
        this.scoreEvent = new GenericEvent();
    }

    protected Row extractFeatures(Map<String, ?> row) {
        return this.featureExtractor.extractFeatures(row);
    }

    protected Row extractFeatures(Iterable<?> row) {
        return this.featureExtractor.extractFeatures(row);
    }

    protected Map<String, ?> extractFeaturesMap(Iterable<?> row) {
        return this.featureExtractor.extractFeaturesMap(row);
    }

    protected Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException fieldMismatchError) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            return this.getField(superClass, fieldName);
        }
    }

    protected Map<String, String> initializeModelInfo(PredictorT predictor) {
        try {
            return (Map)predictor.getClass().getMethod("getModelInfo", new Class[0]).invoke(predictor, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Method getPredictorMethod(String methodName, Class<?> ... signature) {
        try {
            Class<?> explanationClass = this.predictor.getClass();
            return explanationClass.getMethod(methodName, signature);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Prediction explanations are not supported by this model.");
        }
    }

    protected void sendScoreInfo(ScoreEventT eventInfo) {
        this.scoreEvent.notify(eventInfo);
    }

    public LinkedHashMap<String, Class> getFeatures() {
        return this.featureExtractor.getFeatures();
    }

    protected ExplanationParams getDefaultParams() {
        try {
            Class<?> explanationClass = Class.forName(EXPLANATION_UTIL_CLASS_NAME);
            String methodName = "getModelExplanationParams";
            return (ExplanationParams)explanationClass.getMethod(methodName, String.class).invoke(null, this.modelId);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Prediction explanations are not supported by this model.", e);
        }
    }

    protected static class ScoreEventInfoBase<InputT, OutputT>
    extends EventInfoBase {
        protected final InputT input;
        protected final OutputT output;
        protected final Duration duration;

        ScoreEventInfoBase(IPredictorInfo sender, InputT input, OutputT output, Duration duration) {
            super(sender);
            this.input = input;
            this.output = output;
            this.duration = duration;
        }
    }

    protected static class EventInfoBase {
        protected final IPredictorInfo sender;

        EventInfoBase(IPredictorInfo sender) {
            this.sender = sender;
        }
    }

    protected static class GenericEvent<T extends EventInfo>
    implements Event<T>,
    Serializable {
        private final Set<EventHandler<T>> subscribers = new HashSet<EventHandler<T>>();

        GenericEvent() {
        }

        @Override
        public void subscribe(EventHandler<T> eventHandler) {
            this.subscribers.add(eventHandler);
        }

        @Override
        public boolean unsubscribe(EventHandler<T> eventHandler) {
            if (this.subscribers.contains(eventHandler)) {
                this.subscribers.remove(eventHandler);
                return true;
            }
            return false;
        }

        @Override
        public Set<EventHandler<T>> getSubscribers() {
            return this.subscribers;
        }

        void notify(T info) {
            for (EventHandler<T> eventHandler : this.subscribers) {
                eventHandler.handle(info);
            }
        }
    }
}

