/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.internal;

import com.datarobot.prediction.Event;
import com.datarobot.prediction.ExplanationParams;
import com.datarobot.prediction.IPredictorInfo;
import com.datarobot.prediction.IRegressionPredictor;
import com.datarobot.prediction.Predictor;
import com.datarobot.prediction.RegressionScoreEventInfo;
import com.datarobot.prediction.Row;
import com.datarobot.prediction.Score;
import com.datarobot.prediction.internal.PredictorBase;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;

public class RegressionPredictorImpl
extends PredictorBase<Predictor, RegressionScoreEventInfo>
implements IRegressionPredictor,
Serializable {
    private static final String EXPLANATIONS_METHOD = "scoreRegressionWithExplanations";

    protected RegressionPredictorImpl(Predictor predictor) {
        super(predictor);
    }

    @Override
    public double score(Map<String, ?> row) {
        try {
            long start = System.nanoTime();
            Row rowToScore = this.extractFeatures(row);
            double score = this.predictor.score(rowToScore);
            Duration duration = Duration.ofNanos(System.nanoTime() - start);
            this.sendScoreInfo(new ScoreEventInfo((IPredictorInfo)this, row, score, duration));
            return score;
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Scoring is unsuccessful");
        }
    }

    @Override
    public double score(Iterable<?> row) {
        try {
            long start = System.nanoTime();
            Row rowToScore = this.extractFeatures(row);
            double score = this.predictor.score(rowToScore);
            Duration duration = Duration.ofNanos(System.nanoTime() - start);
            if (!this.scoreEvent.getSubscribers().isEmpty()) {
                this.sendScoreInfo(new ScoreEventInfo((IPredictorInfo)this, this.extractFeaturesMap(row), score, duration));
            }
            return score;
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Scoring failed");
        }
    }

    @Override
    public Score<Double> scoreWithExplanations(Map<String, ?> row) {
        return this.scoreWithExplanations(row, null);
    }

    @Override
    public Score<Double> scoreWithExplanations(Iterable<?> row) {
        return this.scoreWithExplanations(this.extractFeaturesMap(row), null);
    }

    @Override
    public Score<Double> scoreWithExplanations(Map<String, ?> row, ExplanationParams predictionExplanationParams) {
        if (predictionExplanationParams == null) {
            predictionExplanationParams = this.getDefaultPredictionExplanationParams();
        }
        long start = System.nanoTime();
        Row features = this.extractFeatures(row);
        try {
            Method predictorMethod = this.getPredictorMethod(EXPLANATIONS_METHOD, Row.class, ExplanationParams.class);
            Score score = (Score)predictorMethod.invoke((Object)this.predictor, features, predictionExplanationParams);
            Duration duration = Duration.ofNanos(System.nanoTime() - start);
            if (!this.scoreEvent.getSubscribers().isEmpty()) {
                this.sendScoreInfo(new ScoreEventInfo((IPredictorInfo)this, row, (Double)score.getScore(), duration));
            }
            return score;
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Score<Double> scoreWithExplanations(Iterable<?> row, ExplanationParams predictionExplanationParams) {
        return this.scoreWithExplanations(this.extractFeaturesMap(row), predictionExplanationParams);
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    @Override
    public Class<?> getPredictorClass() {
        return IRegressionPredictor.class;
    }

    @Override
    public ExplanationParams getDefaultPredictionExplanationParams() {
        return super.getDefaultParams();
    }

    @Override
    public Map<String, String> getModelInfo() {
        return this.modelInfo;
    }

    @Override
    public Event<RegressionScoreEventInfo> getScoreEvent() {
        return this.scoreEvent;
    }

    private static class ScoreEventInfo
    extends PredictorBase.ScoreEventInfoBase<Map<String, ?>, Double>
    implements RegressionScoreEventInfo {
        ScoreEventInfo(IPredictorInfo sender, Map<String, ?> input, Double output, Duration duration) {
            super(sender, input, output, duration);
        }

        @Override
        public Map<String, ?> getInput() {
            return (Map)this.input;
        }

        @Override
        public Double getOutput() {
            return (Double)this.output;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public IPredictorInfo getSender() {
            return this.sender;
        }
    }
}

