/*
 * Decompiled with CFR 0.152.
 */
package com.datarobot.prediction.internal;

import com.datarobot.prediction.Row;
import com.datarobot.prediction.TimeSeriesPredictor;
import com.datarobot.prediction.TimeSeriesRegressionScoreEventInfo;
import com.datarobot.prediction.internal.PredictorBase;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;

public class TimeSeriesBase
extends PredictorBase<TimeSeriesPredictor, TimeSeriesRegressionScoreEventInfo> {
    protected final Map.Entry<Integer, String> timeStep;
    protected final Map.Entry<Integer, Integer> fdw;
    protected final Map.Entry<Integer, Integer> fw;
    protected final String dateColumnName = this.getModelInfoItem("Date-Index-Field");
    protected final String seriesIdColumnName = this.getModelInfoItem("Series-ID-Column");
    protected final String dateFormat;

    protected TimeSeriesBase(TimeSeriesPredictor predictor) {
        super(predictor);
        this.timeStep = this.getTimeStep(this.getModelInfoItem("Time-Step"));
        this.fdw = this.getPositiveWindow(this.getModelInfoItem("Feature-Derivation-Window"));
        this.fw = this.getPositiveWindow(this.getModelInfoItem("Forecast-Window"));
        this.dateFormat = this.getModelInfoItem("Date-Format");
    }

    protected ArrayList<Row> extractRows(ArrayList<Map<String, ?>> inputs) {
        ArrayList<Row> result = new ArrayList<Row>(inputs.size());
        for (Map<String, ?> in : inputs) {
            result.add(this.extractFeatures(in));
        }
        return result;
    }

    private Map.Entry<Integer, Integer> getPositiveWindow(String stringRepresentation) {
        if (stringRepresentation == null) {
            return null;
        }
        stringRepresentation = stringRepresentation.substring(1, stringRepresentation.length() - 1);
        String[] fdwValues = stringRepresentation.split(",");
        int firstValue = Math.abs(Integer.parseInt(fdwValues[0]));
        int secondValue = Math.abs(Integer.parseInt(fdwValues[1]));
        return new AbstractMap.SimpleEntry<Integer, Integer>(Math.min(firstValue, secondValue), Math.max(firstValue, secondValue));
    }

    private Map.Entry<Integer, String> getTimeStep(String stringRepresentation) {
        if (stringRepresentation == null) {
            return null;
        }
        stringRepresentation = stringRepresentation.substring(1, stringRepresentation.length() - 1);
        String[] timeStepValues = stringRepresentation.split(",");
        return new AbstractMap.SimpleEntry<Integer, String>(Integer.parseInt(timeStepValues[0]), timeStepValues[1]);
    }

    private String getModelInfoItem(String name) {
        if (this.modelInfo == null) {
            return null;
        }
        return (String)this.modelInfo.get(name);
    }
}

