/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.commands;

import com.datasonnet.debugger.da.DataSonnetDebugAdapterServer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugAdapterLauncher {
    private static final Logger logger = LoggerFactory.getLogger(DebugAdapterLauncher.class);

    public static void main(String[] args) {
        DebugAdapterLauncher launcher = new DebugAdapterLauncher();
        try {
            launcher.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() throws IOException {
        logger.debug("DataSonnet DebugAdapterLauncher starting");
        Path diPath = Files.createTempFile("dap-in", ".log", new FileAttribute[0]);
        Path doPath = Files.createTempFile("dap-out", ".log", new FileAttribute[0]);
        logger.debug("loggins stdin to " + diPath + " and stdout to " + doPath);
        FileOutputStream fis = new FileOutputStream(diPath.toFile());
        FileOutputStream fos = new FileOutputStream(doPath.toFile());
        TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)System.out, (OutputStream)fos);
        TeeInputStream teeInputStream = new TeeInputStream(System.in, (OutputStream)fis);
        DataSonnetDebugAdapterServer debugServer = new DataSonnetDebugAdapterServer();
        Launcher<IDebugProtocolClient> serverLauncher = DSPLauncher.createServerLauncher(debugServer, (InputStream)teeInputStream, (OutputStream)teeOutputStream);
        IDebugProtocolClient clientProxy = serverLauncher.getRemoteProxy();
        debugServer.connect(clientProxy);
        serverLauncher.startListening();
        logger.debug("DataSonnet DebugAdapterLauncher startListening DONE");
    }
}

