/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.commands;

import com.datasonnet.Mapper;
import com.datasonnet.commands.DebugAdapterLauncher;
import com.datasonnet.commands.Main;
import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Transform data using DataSonnet"}, footer={"Available input and output formats are JSON, XML, and CSV"})
public class Run
implements Callable<Void> {
    @CommandLine.Parameters(index="0", description={"Map file (mime-type is autodetected by suffix, defaulting to JSON)"})
    File datasonnet;
    @CommandLine.Parameters(index="1", arity="0..1", description={"Input data file (if omitted reads from standard input)"})
    File input;
    @CommandLine.Option(names={"-a", "--argument"}, split=",", description={"argument name and value (as JSON)"})
    Map<String, String> arguments = new HashMap<String, String>();
    @CommandLine.Option(names={"-f", "--argument-file"}, split=",", description={"argument name and file containing the value (mime-type is autodetected by suffix, defaulting to JSON)"})
    Map<String, File> argumentFiles = new HashMap<String, File>();
    @CommandLine.Option(names={"-i", "--import-file"}, description={"file to make available for imports"})
    List<File> importFiles = new ArrayList<File>();
    @CommandLine.Option(names={"-n", "--no-wrap"}, description={"Do not wrap in a function call. Only use this if your transformation is already a top-level function."})
    boolean alreadyWrapped = false;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Run the mapper in debug mode, waiting for a debugger to connect."})
    boolean debugMode = false;
    @CommandLine.Option(names={"-o", "--output-type"}, description={"Handle the output as this format. Defaults to JSON."})
    String outputType = "application/json";

    @Override
    public Void call() throws Exception {
        if (this.debugMode) {
            this.startDAPServer();
            new CountDownLatch(1).await();
        } else {
            Mapper mapper = new Mapper(Main.readFile(this.datasonnet), this.combinedArguments().keySet(), this.imports(), !this.alreadyWrapped);
            Document<String> result = mapper.transform(new DefaultDocument<String>(this.payload(), MediaTypes.forExtension(this.suffix(this.datasonnet)).get()), this.combinedArguments(), MediaType.valueOf(this.outputType));
            String contents = result.getContent();
            System.out.println(contents);
        }
        return null;
    }

    private void startDAPServer() throws IOException {
        DebugAdapterLauncher launcher = new DebugAdapterLauncher();
        launcher.start();
    }

    private String suffix(File file) {
        String[] parts = file.getName().split(".");
        if (parts.length > 1) {
            return parts[parts.length - 1];
        }
        return "";
    }

    private String payload() throws IOException {
        if (this.input == null) {
            int current;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            StringBuilder contents = new StringBuilder();
            while ((current = reader.read()) != -1) {
                contents.appendCodePoint(current);
            }
            return contents.toString();
        }
        return Main.readFile(this.input);
    }

    private Map<String, Document<?>> combinedArguments() throws IOException {
        return Collections.unmodifiableMap(new HashMap<String, Document<String>>(){
            {
                for (Map.Entry<String, String> entry : Run.this.arguments.entrySet()) {
                    this.put(entry.getKey(), new DefaultDocument<String>(entry.getValue(), MediaTypes.APPLICATION_JSON));
                }
                for (Map.Entry<String, Object> entry : Run.this.argumentFiles.entrySet()) {
                    File file = (File)entry.getValue();
                    String contents = Main.readFile(file);
                    this.put(entry.getKey(), new DefaultDocument<String>(contents, MediaTypes.forExtension(Run.this.suffix(file)).get()));
                }
            }
        });
    }

    private Map<String, String> imports() throws IOException {
        HashMap<String, String> imports = new HashMap<String, String>();
        for (File importFile : this.importFiles) {
            String name = importFile.getPath();
            String contents = Main.readFile(importFile);
            imports.put(name, contents);
        }
        return Collections.unmodifiableMap(imports);
    }
}

