/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.debugger;

import com.datasonnet.debugger.Breakpoint;
import com.datasonnet.debugger.SourcePos;
import com.datasonnet.debugger.StoppedProgramContext;
import com.datasonnet.debugger.ValueInfo;
import com.datasonnet.debugger.da.DataSonnetDebugListener;
import com.datasonnet.jsonnet.EvalScope;
import com.datasonnet.jsonnet.Evaluator;
import com.datasonnet.jsonnet.Expr;
import com.datasonnet.jsonnet.FileScope;
import com.datasonnet.jsonnet.Interpreter;
import com.datasonnet.jsonnet.Materializer;
import com.datasonnet.jsonnet.Parser;
import com.datasonnet.jsonnet.Val;
import com.datasonnet.jsonnet.ValScope;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public class DataSonnetDebugger {
    public static final String SELF_VAR_NAME = "self";
    public static final String SUPER_VAR_NAME = "super";
    public static final String DOLLAR_VAR_NAME = "$";
    private static final Logger logger = LoggerFactory.getLogger(DataSonnetDebugger.class);
    private static DataSonnetDebugger DEBUGGER;
    private final ConcurrentMap<Integer, Breakpoint> breakpoints = new ConcurrentHashMap<Integer, Breakpoint>();
    private DataSonnetDebugListener debugListener;
    private AtomicBoolean attached = new AtomicBoolean(false);
    private CountDownLatch latch;
    private AtomicBoolean stepMode = new AtomicBoolean(false);
    private StoppedProgramContext spc;
    private AtomicInteger lineCount = new AtomicInteger(-1);
    private AtomicInteger diffOffset = new AtomicInteger(-1);
    private ValScope currentValScope;
    private FileScope currentFileScope;
    private EvalScope currentEvalScope;

    public static DataSonnetDebugger getDebugger() {
        if (DEBUGGER == null) {
            DEBUGGER = new DataSonnetDebugger();
        }
        return DEBUGGER;
    }

    public void addBreakpoint(int line) {
        this.addBreakpoint(line, false);
    }

    public void addBreakpoint(int line, boolean temporary) {
        this.breakpoints.put(line, new Breakpoint(line, temporary));
    }

    public Breakpoint getBreakpoint(int line) {
        return (Breakpoint)this.breakpoints.get(line);
    }

    public void removeBreakpoint(int line) {
        this.breakpoints.remove(line);
    }

    public void clearBreakpoints() {
        this.breakpoints.clear();
    }

    public void probeExpr(Expr expr, ValScope valScope, FileScope fileScope, EvalScope evalScope) {
        SourcePos sourcePos;
        if (this.isAttached()) {
            this.detach(false);
        }
        if ((sourcePos = this.getSourcePos(expr, fileScope)) == null) {
            logger.debug("sourcePos is null, returning");
            if (!this.isAttached()) {
                this.attach(false);
            }
            return;
        }
        int line = sourcePos.getLine();
        Breakpoint breakpoint = (Breakpoint)this.breakpoints.get(line);
        logger.debug("line " + line + " breakpoints " + breakpoint);
        if (this.isStepMode() || breakpoint != null && breakpoint.isEnabled()) {
            this.saveContext(expr, valScope, fileScope, evalScope, sourcePos);
            if (this.debugListener != null) {
                this.debugListener.stopped(this.spc);
            }
            this.setStepMode(true);
            this.latch = new CountDownLatch(1);
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            logger.debug("Resuming after await");
            this.cleanContext();
            if (breakpoint != null && breakpoint.isTemporary()) {
                this.breakpoints.remove(line);
            }
        }
        if (!this.isAttached()) {
            this.attach(false);
        }
    }

    public Object evaluateExpression(String expression) {
        if (this.isAttached()) {
            this.detach(false);
        }
        Parser.setCachedIndices(this.currentFileScope.nameIndices());
        Interpreter interpreter = new Interpreter((Evaluator)this.currentEvalScope);
        Either<String, Expr> either = interpreter.parse(expression, this.currentFileScope.currentFile());
        if (either.isLeft()) {
            return either.left().get();
        }
        Expr expr = (Expr)either.right().get();
        Object value = "";
        try {
            Val exprVal = this.currentEvalScope.visitExpr(expr, this.currentValScope, this.currentFileScope);
            value = this.mapValue(exprVal, "", this.currentEvalScope, true);
        }
        catch (Exception e) {
            value = e;
        }
        Parser.setCachedIndices(null);
        if (!this.isAttached()) {
            this.attach(false);
        }
        return value;
    }

    private void cleanContext() {
        this.spc = null;
    }

    public StoppedProgramContext getStoppedProgramContext() {
        return this.spc;
    }

    private void saveContext(Expr expr, ValScope valScope, FileScope fileScope, EvalScope evalScope, SourcePos sourcePos) {
        if (this.isAttached()) {
            this.detach(false);
        }
        this.currentFileScope = fileScope;
        this.currentValScope = valScope;
        this.currentEvalScope = evalScope;
        StoppedProgramContext spc = new StoppedProgramContext();
        spc.setSourcePos(sourcePos);
        HashMap<String, Object> namedVariables = new HashMap<String, Object>();
        namedVariables.put(SELF_VAR_NAME, valScope.self0().nonEmpty() ? this.mapValue((Val)valScope.self0().get(), SELF_VAR_NAME, evalScope, false) : null);
        namedVariables.put(SUPER_VAR_NAME, valScope.super0().nonEmpty() ? this.mapValue((Val)valScope.super0().get(), SUPER_VAR_NAME, evalScope, false) : null);
        namedVariables.put(DOLLAR_VAR_NAME, valScope.dollar0().nonEmpty() ? this.mapValue((Val)valScope.dollar0().get(), DOLLAR_VAR_NAME, evalScope, false) : null);
        logger.debug("saveContext. namedVariables is: " + namedVariables);
        Map<String, Object> nameIndices = fileScope.nameIndices();
        Val.Lazy[] bindings = valScope.getBindings();
        for (int idx = 0; idx < bindings.length; ++idx) {
            Option<String> name;
            Val.Lazy nextBinding = bindings[idx];
            if (nextBinding == null || !(name = fileScope.getNameByIndex(idx)).nonEmpty()) continue;
            String nameStr = (String)name.get();
            logger.debug("Next binding name is: " + nameStr);
            if (nameStr.equals("std") || nameStr.equals("cml")) continue;
            Val forced = nextBinding.force();
            Object mapped = this.mapValue(forced, nameStr, evalScope, true);
            namedVariables.put(nameStr, mapped);
            logger.debug("Binding '" + nameStr + "' value is: " + mapped);
        }
        spc.setNamedVariables(namedVariables);
        this.spc = spc;
        if (!this.isAttached()) {
            this.attach(false);
        }
    }

    private Object mapValue(@Nullable Val theVal, String name, EvalScope evalScope, boolean isBinding) {
        Object mapped = null;
        if (theVal instanceof Val.Obj) {
            Val.Obj objectValue = (Val.Obj)theVal;
            if (isBinding && objectValue.valueCache().isEmpty()) {
                Materializer.apply(objectValue, evalScope);
            }
            ConcurrentHashMap mappedObject = new ConcurrentHashMap();
            objectValue.foreachVisibleKey((Function2<String, Expr.Member.Visibility, BoxedUnit>)((Function2)(key, visibility) -> {
                Option member = objectValue.valueCache().get(key);
                if (member.nonEmpty() && !SELF_VAR_NAME.equals(key) && !DOLLAR_VAR_NAME.equals(key) && !SUPER_VAR_NAME.equals(key)) {
                    Val memberVal = (Val)member.get();
                    Object mappedVal = this.mapValue(memberVal, (String)key, evalScope, isBinding);
                    mappedObject.put(key, mappedVal instanceof ValueInfo ? (ValueInfo)mappedVal : new ValueInfo(memberVal.sourcePosition(), (String)key, mappedVal));
                } else {
                    mappedObject.put(key, new ValueInfo(0, (String)key, null));
                }
                return null;
            }));
            mapped = mappedObject;
        } else if (theVal instanceof Val.Arr) {
            Val.Arr arrValue = (Val.Arr)theVal;
            CopyOnWriteArrayList mappedArr = new CopyOnWriteArrayList();
            arrValue.value().foreach(member -> {
                Val memberVal = member.force();
                Materializer.apply(memberVal, evalScope);
                Object mappedVal = this.mapValue(memberVal, "", evalScope, isBinding);
                mappedArr.add(mappedVal instanceof ValueInfo ? (ValueInfo)mappedVal : new ValueInfo(memberVal.sourcePosition(), "", this.mapValue(memberVal, "", evalScope, isBinding)));
                return null;
            });
            mapped = mappedArr;
        } else {
            mapped = theVal instanceof Val.Func ? new ValueInfo(theVal.sourcePosition(), name, "FUNCTION") : new ValueInfo(theVal.sourcePosition(), name, Materializer.apply(theVal, evalScope));
        }
        return mapped;
    }

    public int getDiffOffset() {
        return this.diffOffset.get();
    }

    private SourcePos getSourcePos(Expr expr, FileScope fileScope) {
        if (fileScope.source() != null && fileScope.source().length() > 0) {
            String sourceCode = fileScope.source();
            int diffLinesCount = 0;
            if (this.lineCount.get() != -1) {
                String[] sourceLines = sourceCode.split("\\R");
                diffLinesCount = sourceLines.length - this.lineCount.get();
                CharSequence[] diffLines = Arrays.copyOfRange(sourceLines, 0, diffLinesCount);
                logger.debug("diffLines: " + (String[])diffLines);
                this.diffOffset.set(String.join((CharSequence)System.lineSeparator(), diffLines).length());
                logger.debug("diffOffset: " + this.diffOffset.get());
            }
            String sourceBeforeCaret = sourceCode.substring(0, expr.offset() + 1);
            int caretLine = sourceBeforeCaret.split("\\R").length - diffLinesCount - 1;
            int caretPos = expr.offset() - this.diffOffset.get();
            logger.debug("Caret Position: " + caretPos);
            if (caretPos < 0) {
                logger.debug("CaretPos is in invisible code, returning null...");
                return null;
            }
            if (caretPos > sourceCode.length()) {
                logger.error("CaretPos: " + caretPos + " > sourceCode.length() " + sourceCode.length());
                return null;
            }
            SourcePos sourcePos = new SourcePos();
            sourcePos.setCurrentFile(Objects.toString(fileScope.currentFile()));
            sourcePos.setCaretPos(caretPos);
            sourcePos.setLine(caretLine);
            sourcePos.setCaretPosInLine(expr.offset() - (sourceBeforeCaret.lastIndexOf("\n") + 1));
            return sourcePos;
        }
        return null;
    }

    public void resume() {
        logger.debug("Resume command received");
        if (this.latch != null && this.latch.getCount() > 0L) {
            logger.debug("latch.countDown");
            this.latch.countDown();
        }
    }

    public void attach() {
        this.attach(true);
    }

    public void attach(boolean clear) {
        if (!this.isAttached()) {
            this.attached.set(true);
            System.setProperty("debug", "true");
            if (clear) {
                this.breakpoints.clear();
                this.setStepMode(false);
            }
        }
    }

    public void detach() {
        this.detach(true);
    }

    public void detach(boolean clear) {
        this.attached.set(false);
        System.setProperty("debug", "false");
        if (clear) {
            this.breakpoints.clear();
            this.setStepMode(false);
            this.resume();
        }
    }

    public boolean isAttached() {
        return this.attached.get();
    }

    public void setStepMode(boolean stepMode) {
        this.stepMode.set(stepMode);
    }

    public boolean isStepMode() {
        return this.stepMode.get();
    }

    public void setDebuggerAdapter(DataSonnetDebugListener dataSonnetDebugListener) {
        this.debugListener = dataSonnetDebugListener;
    }

    public int getLineCount() {
        return this.lineCount.get();
    }

    public void setLineCount(int lineCount) {
        this.lineCount.set(lineCount);
    }
}

