/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.debugger.da;

import com.datasonnet.Mapper;
import com.datasonnet.debugger.DataSonnetDebugger;
import com.datasonnet.debugger.SourcePos;
import com.datasonnet.debugger.StoppedProgramContext;
import com.datasonnet.debugger.da.DataSonnetDebugListener;
import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.SourcePresentationHint;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackFramePresentationHint;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablePresentationHint;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSonnetDebugAdapterServer
implements IDebugProtocolServer,
DataSonnetDebugListener {
    private static final Logger logger = LoggerFactory.getLogger(DataSonnetDebugAdapterServer.class);
    private static final int DATASONNET_THREAD_ID = 0;
    public static final int REF_VARIABLES_REFERENCE_ID = 256;
    public static final int BINDINGS_VARIABLES_REFERENCE_ID = 257;
    public static final int EXT_VARIABLES_REFERENCE_ID = 258;
    public static final int SELF_VAR_REF = 260;
    public static final int SUPER_VAR_REF = 261;
    public static final int DOLLAR_VAR_REF = 262;
    private Map<Integer, Variable> variablesMap = new HashMap<Integer, Variable>();
    private AtomicInteger variablesKeyGenerator = new AtomicInteger();
    private volatile IDebugProtocolClient client;
    private final Map<String, Set<String>> sourceToBreakpointIds = new ConcurrentHashMap<String, Set<String>>();
    private Thread fakerThread;
    private Thread mapperThread;
    private Mapper mapper;
    private String program;
    private String programBaseName;
    private String script;
    private String payload = "{}";
    private MediaType outputType = MediaTypes.APPLICATION_JSON;
    private String resultVariable;
    private InitializeRequestArguments initializeRequestArguments;

    public void connect(IDebugProtocolClient clientProxy) {
        this.client = clientProxy;
    }

    @Override
    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        logger.info("initialize. args:" + args);
        return DataSonnetDebugAdapterServer.supplyAsync(() -> {
            this.initializeRequestArguments = args;
            Capabilities capabilities = new Capabilities();
            capabilities.setSupportsSetVariable(Boolean.FALSE);
            capabilities.setSupportsConditionalBreakpoints(Boolean.FALSE);
            capabilities.setSupportsFunctionBreakpoints(Boolean.FALSE);
            capabilities.setSupportsBreakpointLocationsRequest(Boolean.FALSE);
            capabilities.setSupportsExceptionOptions(Boolean.FALSE);
            capabilities.setSupportsExceptionInfoRequest(Boolean.FALSE);
            capabilities.setSupportsExceptionFilterOptions(Boolean.FALSE);
            capabilities.setSupportsConfigurationDoneRequest(Boolean.TRUE);
            capabilities.setSupportsRestartRequest(Boolean.FALSE);
            capabilities.setSupportSuspendDebuggee(Boolean.FALSE);
            capabilities.setSupportsValueFormattingOptions(Boolean.FALSE);
            capabilities.setSupportTerminateDebuggee(true);
            capabilities.setSupportsSingleThreadExecutionRequests(Boolean.FALSE);
            capabilities.setSupportsCancelRequest(Boolean.FALSE);
            logger.info("Returning capabilities..." + capabilities);
            return capabilities;
        });
    }

    @Override
    public CompletableFuture<Void> attach(Map<String, Object> args) {
        return DataSonnetDebugAdapterServer.runAsync(() -> {
            logger.info("attach; args:" + args);
            OutputEventArguments oea = new OutputEventArguments();
            oea.setOutput("attach request not supported");
            this.client.output(oea);
        });
    }

    @Override
    public CompletableFuture<Void> launch(Map<String, Object> args) {
        logger.info("launch; args:" + args);
        return DataSonnetDebugAdapterServer.runAsync(() -> {
            try {
                String outputMime;
                this.program = (String)args.get("program");
                this.programBaseName = (String)args.get("fileBasename");
                this.script = DataSonnetDebugAdapterServer.readFileAsString(this.program);
                String payloadFileName = (String)args.get("payload");
                if (payloadFileName != null) {
                    this.payload = DataSonnetDebugAdapterServer.readFileAsString(payloadFileName);
                }
                if ((outputMime = (String)args.get("outputType")) != null) {
                    this.outputType = MediaType.parseMediaType(outputMime);
                }
                logger.info("Running mapper for script: " + this.script);
                this.mapper = new Mapper(this.script);
                DataSonnetDebugger debugger = DataSonnetDebugger.getDebugger();
                boolean launched = true;
                if (launched) {
                    Thread initializedThread = new Thread(this::initializedCallback, "initialized callback");
                    initializedThread.start();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void initializedCallback() {
        this.client.initialized();
    }

    @Override
    public void stopped(StoppedProgramContext stoppedProgramContext) {
        logger.info("DatasonnetDebugger callback. stoppedProgramContext: " + stoppedProgramContext);
        this.resetVariablesCache();
        StoppedEventArguments args = new StoppedEventArguments();
        args.setReason("step");
        args.setPreserveFocusHint(false);
        args.setText("step");
        args.setAllThreadsStopped(true);
        args.setDescription("step");
        args.setThreadId(0);
        this.client.stopped(args);
    }

    private void resetVariablesCache() {
        this.variablesMap.clear();
        this.variablesKeyGenerator = new AtomicInteger();
    }

    @Override
    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments setBreakpointsArguments) {
        logger.info("setBreakpoints");
        return DataSonnetDebugAdapterServer.supplyAsync(() -> this.setBreakpointsSync(setBreakpointsArguments));
    }

    private SetBreakpointsResponse setBreakpointsSync(SetBreakpointsArguments setBreakpointsArguments) {
        DataSonnetDebugger.getDebugger().clearBreakpoints();
        SetBreakpointsResponse response = new SetBreakpointsResponse();
        response.setBreakpoints(new Breakpoint[0]);
        Source source = setBreakpointsArguments.getSource();
        if (source.getName() != null && source.getName().equals(this.programBaseName) && source.getPath() != null && source.getPath().equals(this.program)) {
            Object[] sourceBreakpoints = setBreakpointsArguments.getBreakpoints();
            logger.debug("creating breakpoints for " + Arrays.toString(sourceBreakpoints));
            Object[] breakpoints = new Breakpoint[sourceBreakpoints.length];
            for (int i = 0; i < sourceBreakpoints.length; ++i) {
                Object sourceBreakpoint = sourceBreakpoints[i];
                int line = ((SourceBreakpoint)sourceBreakpoint).getLine();
                ++line;
                DataSonnetDebugger.getDebugger().addBreakpoint(--line);
                Breakpoint bp = new Breakpoint();
                bp.setId(i);
                bp.setLine(line);
                bp.setVerified(true);
                breakpoints[i] = bp;
            }
            response.setBreakpoints((Breakpoint[])breakpoints);
            logger.debug("created breakpoints " + Arrays.toString(breakpoints));
        }
        return response;
    }

    @Override
    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        return DataSonnetDebugAdapterServer.runAsync(() -> {
            DataSonnetDebugger.getDebugger().attach(false);
            DataSonnetDebugger.getDebugger().setDebuggerAdapter(this);
            this.mapperThread = new Thread(() -> {
                logger.info("running mapper.transform.");
                try {
                    String mappedJson = this.mapper.transform(new DefaultDocument<String>(this.payload, MediaTypes.APPLICATION_JSON), Collections.emptyMap(), this.outputType).getContent();
                    logger.info("mappedJson: " + mappedJson);
                    this.resultVariable = mappedJson;
                    this.output("stdout", this.resultVariable);
                    this.terminated();
                    this.exited(1);
                }
                catch (Exception ex) {
                    logger.error("Running mapper", (Throwable)ex);
                    this.outputError("Script execution finished with an error:\n" + ex.getMessage());
                    this.terminated();
                    this.exited(1);
                }
            }, "DataSonnet Thread");
            this.mapperThread.start();
        });
    }

    private void terminated() {
        TerminatedEventArguments args = new TerminatedEventArguments();
        args.setRestart(false);
        this.client.terminated(args);
    }

    private void exited(int i) {
        ExitedEventArguments args = new ExitedEventArguments();
        args.setExitCode(i);
        this.client.exited(args);
    }

    private void outputError(String msg) {
        this.output("stderr", msg);
    }

    private void outputInfo(String msg) {
        this.output("console", msg);
    }

    private void output(String category, String msg) {
        OutputEventArguments args = new OutputEventArguments();
        args.setCategory(category);
        args.setOutput(msg);
        logger.debug("Sending: {}", (Object)args);
        this.client.output(args);
    }

    @Override
    public CompletableFuture<ThreadsResponse> threads() {
        logger.info("threads");
        return DataSonnetDebugAdapterServer.supplyAsync(() -> {
            ThreadsResponse value = new ThreadsResponse();
            org.eclipse.lsp4j.debug.Thread t1 = new org.eclipse.lsp4j.debug.Thread();
            t1.setId(0);
            t1.setName("Datasonnet main thread");
            value.setThreads(new org.eclipse.lsp4j.debug.Thread[]{t1});
            return value;
        });
    }

    @Override
    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        logger.info("stackTrace: " + args.toString());
        return DataSonnetDebugAdapterServer.supplyAsync(() -> {
            StackTraceResponse response = new StackTraceResponse();
            StackFrame sf0 = new StackFrame();
            sf0.setId(0);
            sf0.setSource(this.getCurrentSource());
            if (this.getStoppedAtSourcePos() != null) {
                int sourcePosLine = this.getStoppedAtSourcePos().getLine();
                if (this.initializeRequestArguments.getLinesStartAt1().booleanValue()) {
                    ++sourcePosLine;
                }
                sf0.setLine(--sourcePosLine);
                int sourcePosCaretInLine = this.getStoppedAtSourcePos().getCaretPosInLine();
                if (this.initializeRequestArguments.getColumnsStartAt1().booleanValue()) {
                    ++sourcePosCaretInLine;
                }
                sf0.setColumn(sourcePosCaretInLine);
                sf0.setEndLine(sourcePosLine);
            }
            sf0.setName("mapper");
            sf0.setCanRestart(false);
            sf0.setPresentationHint(StackFramePresentationHint.NORMAL);
            sf0.setSource(this.getCurrentSource());
            response.setStackFrames(new StackFrame[]{sf0});
            return response;
        });
    }

    private SourcePos getStoppedAtSourcePos() {
        return DataSonnetDebugger.getDebugger().getStoppedProgramContext() != null ? DataSonnetDebugger.getDebugger().getStoppedProgramContext().getSourcePos() : null;
    }

    private Source getCurrentSource() {
        Source src = new Source();
        src.setName(this.programBaseName);
        src.setPath(this.program);
        src.setSourceReference(0);
        src.setPresentationHint(SourcePresentationHint.NORMAL);
        src.setOrigin("client");
        return src;
    }

    @Override
    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        logger.info("scopes");
        return DataSonnetDebugAdapterServer.supplyAsync(() -> {
            ScopesResponse response = new ScopesResponse();
            Scope refsScope = this.getRefsScope();
            Scope bindingsScope = this.getBindingsScope();
            response.setScopes(new Scope[]{refsScope, bindingsScope});
            return response;
        });
    }

    @NotNull
    private Scope getRefsScope() {
        Scope refsScope = new Scope();
        refsScope.setName("refs");
        refsScope.setVariablesReference(256);
        refsScope.setNamedVariables(3);
        refsScope.setIndexedVariables(0);
        refsScope.setPresentationHint("arguments");
        refsScope.setSource(this.getCurrentSource());
        return refsScope;
    }

    @NotNull
    private Scope getBindingsScope() {
        Scope bindingsScope = new Scope();
        bindingsScope.setName("locals");
        bindingsScope.setVariablesReference(257);
        bindingsScope.setNamedVariables(this.getBoundVariables().size());
        bindingsScope.setIndexedVariables(0);
        bindingsScope.setPresentationHint("locals");
        bindingsScope.setSource(this.getCurrentSource());
        return bindingsScope;
    }

    @Override
    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        return DataSonnetDebugAdapterServer.supplyAsync(() -> {
            VariablesResponse response = new VariablesResponse();
            if (args.getVariablesReference() == 256) {
                List<Variable> vars = this.getRefVariables();
                response.setVariables(vars.toArray(new Variable[0]));
            } else if (args.getVariablesReference() == 257) {
                List<Variable> vars = this.getBoundVariables();
                response.setVariables(vars.toArray(new Variable[0]));
            } else if (args.getVariablesReference() == 260 || args.getVariablesReference() == 261 || args.getVariablesReference() == 262) {
                // empty if block
            }
            return response;
        });
    }

    private List<Variable> getRefVariables() {
        StoppedProgramContext spc = DataSonnetDebugger.getDebugger().getStoppedProgramContext();
        if (spc == null || spc.getNamedVariables() == null) {
            return List.of();
        }
        Object selfValue = spc.getNamedVariables().get("self");
        Variable self_ = this.createRefVariable("self", "Object", selfValue == null ? "null" : selfValue.toString(), 260);
        Object superValue = spc.getNamedVariables().get("super");
        Variable super_ = this.createRefVariable("super", "Object", superValue == null ? "null" : superValue.toString(), 261);
        Object dollarValue = spc.getNamedVariables().get("$");
        Variable dollar_ = this.createRefVariable("$", "Object", dollarValue == null ? "null" : dollarValue.toString(), 262);
        return List.of(self_, super_, dollar_);
    }

    private List<Variable> getBoundVariables() {
        StoppedProgramContext spc = DataSonnetDebugger.getDebugger().getStoppedProgramContext();
        if (spc == null || spc.getNamedVariables() == null) {
            return List.of();
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        Set<String> avoided = Set.of("self", "super", "$");
        spc.getNamedVariables().forEach((k, v) -> {
            if (!avoided.contains(k)) {
                vars.add(this.createLocalVariable((String)k, "Object", v == null ? "null" : v.toString(), this.variablesKeyGenerator.incrementAndGet()));
            }
        });
        return vars;
    }

    private Variable createLocalVariable(String name, String type, String value, int ref) {
        Variable var_ = new Variable();
        var_.setValue(value);
        var_.setType(type);
        var_.setName(name);
        VariablePresentationHint ph = new VariablePresentationHint();
        ph.setKind("local");
        ph.setAttributes(new String[]{"readOnly"});
        ph.setVisibility("final");
        ph.setLazy(false);
        var_.setPresentationHint(ph);
        var_.setVariablesReference(ref);
        var_.setNamedVariables(0);
        var_.setIndexedVariables(0);
        return var_;
    }

    private Variable createRefVariable(String name, String type, String value, int ref) {
        Variable var_ = new Variable();
        var_.setValue(value);
        var_.setType(type);
        var_.setName(name);
        VariablePresentationHint ph = new VariablePresentationHint();
        ph.setKind("virtual");
        ph.setAttributes(new String[]{"readOnly"});
        ph.setVisibility("final");
        ph.setLazy(false);
        var_.setPresentationHint(ph);
        var_.setVariablesReference(ref);
        var_.setNamedVariables(0);
        var_.setIndexedVariables(0);
        return var_;
    }

    @NotNull
    private Variable createResultVar() {
        Variable res = new Variable();
        res.setValue(this.resultVariable);
        res.setType("string");
        res.setName("<result>");
        VariablePresentationHint ph = new VariablePresentationHint();
        ph.setKind("virtual");
        ph.setAttributes(new String[]{"readOnly"});
        ph.setVisibility("final");
        ph.setLazy(false);
        res.setPresentationHint(ph);
        res.setVariablesReference(0);
        res.setNamedVariables(0);
        res.setIndexedVariables(0);
        return res;
    }

    @Override
    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        return DataSonnetDebugAdapterServer.supplyAsync(() -> {
            ContinueResponse response = new ContinueResponse();
            int threadId = args.getThreadId();
            if (threadId == 0) {
                DataSonnetDebugAdapterServer.runAsync(() -> {
                    DataSonnetDebugger.getDebugger().setStepMode(false);
                    DataSonnetDebugger.getDebugger().resume();
                });
                response.setAllThreadsContinued(Boolean.TRUE);
                return response;
            }
            throw new RuntimeException("Unknown thread id: " + threadId);
        });
    }

    @Override
    public CompletableFuture<Void> next(NextArguments args) {
        return DataSonnetDebugAdapterServer.runAsync(() -> {
            logger.info("next: " + args);
            DataSonnetDebugger.getDebugger().resume();
        });
    }

    @Override
    public CompletableFuture<Void> stepIn(StepInArguments args) {
        NextArguments nextArgs = new NextArguments();
        nextArgs.setThreadId(args.getThreadId());
        nextArgs.setGranularity(args.getGranularity());
        nextArgs.setSingleThread(args.getSingleThread());
        return this.next(nextArgs);
    }

    @Override
    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        NextArguments nextArgs = new NextArguments();
        nextArgs.setThreadId(args.getThreadId());
        nextArgs.setGranularity(args.getGranularity());
        nextArgs.setSingleThread(args.getSingleThread());
        return this.next(nextArgs);
    }

    @Override
    public CompletableFuture<Void> terminate(TerminateArguments args) {
        return DataSonnetDebugAdapterServer.runAsync(() -> {
            DataSonnetDebugger.getDebugger().detach();
            DataSonnetDebugger.getDebugger().setDebuggerAdapter(null);
        });
    }

    @Override
    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        return DataSonnetDebugAdapterServer.runAsync(() -> {
            DataSonnetDebugger.getDebugger().detach();
            DataSonnetDebugger.getDebugger().setDebuggerAdapter(null);
        });
    }

    @Override
    public CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        return DataSonnetDebugAdapterServer.supplyAsync(() -> {
            throw new RuntimeException("setVariable not supported");
        });
    }

    private static CompletableFuture<Void> runAsync(Runnable runnable) {
        ClassLoader callerCCL = Thread.currentThread().getContextClassLoader();
        return CompletableFuture.runAsync(() -> {
            ClassLoader currentCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(callerCCL);
                runnable.run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCCL);
            }
        });
    }

    private static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        ClassLoader callerCCL = Thread.currentThread().getContextClassLoader();
        return CompletableFuture.supplyAsync(() -> {
            ClassLoader currentCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(callerCCL);
                Object t = supplier.get();
                return t;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCCL);
            }
        });
    }

    public static String readFileAsString(String filePath) throws IOException {
        return new String(DataSonnetDebugAdapterServer.readFileAsBytes(filePath));
    }

    public static byte[] readFileAsBytes(String filePath) throws IOException {
        Path path = new File(filePath).toPath();
        return Files.readAllBytes(path);
    }

    private void startFaker() {
        this.fakerThread = new Thread(this::fakeStop, "DSl DAP - Faker");
        this.fakerThread.start();
    }

    private void fakeStop() {
        while (!this.fakerThread.isInterrupted()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (this.client == null) continue;
            StoppedEventArguments args = new StoppedEventArguments();
            args.setReason("entry");
            args.setReason("goto");
            args.setReason("exception");
            args.setReason("function breakpoint");
            args.setReason("step");
            args.setReason("breakpoint");
            args.setPreserveFocusHint(true);
            args.setText("breakpoint such and such was hit");
            args.setAllThreadsStopped(true);
            args.setDescription("breakpoint HIT");
            args.setHitBreakpointIds(new Integer[]{2});
            args.setThreadId(0);
            this.client.stopped(args);
        }
    }
}

