/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.plugins;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.plugins.BaseJacksonDataFormatPlugin;
import com.datasonnet.spi.PluginException;
import com.datasonnet.spi.ujsonUtils;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ujson.Null$;
import ujson.Value;

public class DefaultCSVFormatPlugin
extends BaseJacksonDataFormatPlugin {
    public static final String DS_PARAM_USE_HEADER = "useheader";
    public static final String DS_PARAM_QUOTE_CHAR = "quote";
    public static final String DS_PARAM_SEPARATOR_CHAR = "separator";
    public static final String DS_PARAM_ESCAPE_CHAR = "escape";
    public static final String DS_PARAM_NEW_LINE = "newline";
    public static final String DS_PARAM_HEADERS = "headers";
    public static final String DS_PARAM_DISABLE_QUOTES = "disablequotes";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final CsvMapper CSV_MAPPER = new CsvMapper();

    public DefaultCSVFormatPlugin() {
        this.supportedTypes.add(MediaTypes.APPLICATION_CSV);
        this.supportedTypes.add(MediaType.parseMediaType("text/csv"));
        this.readerParams.add(DS_PARAM_USE_HEADER);
        this.readerParams.add(DS_PARAM_QUOTE_CHAR);
        this.readerParams.add(DS_PARAM_SEPARATOR_CHAR);
        this.readerParams.add(DS_PARAM_ESCAPE_CHAR);
        this.readerParams.add(DS_PARAM_NEW_LINE);
        this.readerParams.add(DS_PARAM_HEADERS);
        this.readerParams.add(DS_PARAM_DISABLE_QUOTES);
        this.writerParams.addAll(this.readerParams);
        this.readerSupportedClasses.add(InputStream.class);
        this.readerSupportedClasses.add(byte[].class);
        this.readerSupportedClasses.add(String.class);
        this.writerSupportedClasses.add(OutputStream.class);
        this.writerSupportedClasses.add(byte[].class);
        this.writerSupportedClasses.add(String.class);
    }

    private boolean isUseHeader(MediaType mediaType) {
        if (mediaType.getParameter(DS_PARAM_USE_HEADER) != null) {
            return Boolean.parseBoolean(mediaType.getParameter(DS_PARAM_USE_HEADER));
        }
        return true;
    }

    @Override
    public Value read(Document<?> doc) throws PluginException {
        if (doc.getContent() == null) {
            return Null$.MODULE$;
        }
        CsvSchema.Builder builder = this.getBuilder(doc.getMediaType());
        boolean useHeader = this.isUseHeader(doc.getMediaType());
        CsvSchema csvSchema = builder.build();
        try {
            if (String.class.isAssignableFrom(doc.getContent().getClass())) {
                JsonNode result = CSV_MAPPER.readerFor(useHeader ? Map.class : List.class).with((FormatSchema)csvSchema).readTree((String)doc.getContent());
                return this.ujsonFrom(result);
            }
            if (byte[].class.isAssignableFrom(doc.getContent().getClass())) {
                JsonNode result = CSV_MAPPER.readerFor(useHeader ? Map.class : List.class).with((FormatSchema)csvSchema).readTree((byte[])doc.getContent());
                return this.ujsonFrom(result);
            }
            if (InputStream.class.isAssignableFrom(doc.getContent().getClass())) {
                JsonNode result = CSV_MAPPER.readerFor(useHeader ? Map.class : List.class).with((FormatSchema)csvSchema).readTree((InputStream)doc.getContent());
                return this.ujsonFrom(result);
            }
            throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canRead before invoking read"));
        }
        catch (JsonProcessingException jpe) {
            throw new PluginException("Unable to convert CSV to JSON", jpe);
        }
        catch (IOException ioe) {
            throw new PluginException("Unable to read CSV input", ioe);
        }
    }

    @Override
    public <T> Document<T> write(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        Map<String, String> params = mediaType.getParameters();
        CsvSchema.Builder builder = this.getBuilder(mediaType);
        try {
            JsonNode jsonTree = OBJECT_MAPPER.valueToTree(ujsonUtils.javaObjectFrom(input));
            if (this.isUseHeader(mediaType)) {
                if (params.containsKey(DS_PARAM_HEADERS)) {
                    String[] headers;
                    for (String header : headers = params.get(DS_PARAM_HEADERS).split(",")) {
                        builder.addColumn(header);
                    }
                } else {
                    JsonNode firstObject = (JsonNode)jsonTree.elements().next();
                    firstObject.fieldNames().forEachRemaining(arg_0 -> ((CsvSchema.Builder)builder).addColumn(arg_0));
                }
            }
            CsvSchema csvSchema = builder.build();
            if (targetType.isAssignableFrom(String.class)) {
                return new DefaultDocument<String>(CSV_MAPPER.writerFor(JsonNode.class).with((FormatSchema)csvSchema).writeValueAsString((Object)jsonTree), MediaTypes.APPLICATION_CSV);
            }
            if (targetType.isAssignableFrom(OutputStream.class)) {
                BufferedOutputStream out = new BufferedOutputStream(new ByteArrayOutputStream());
                CSV_MAPPER.writerFor(JsonNode.class).with((FormatSchema)csvSchema).writeValue((OutputStream)out, (Object)jsonTree);
                return new DefaultDocument<BufferedOutputStream>(out, MediaTypes.APPLICATION_CSV);
            }
            if (targetType.isAssignableFrom(byte[].class)) {
                return new DefaultDocument<byte[]>(CSV_MAPPER.writerFor(JsonNode.class).with((FormatSchema)csvSchema).writeValueAsBytes((Object)jsonTree), MediaTypes.APPLICATION_CSV);
            }
            throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canWrite before invoking write"));
        }
        catch (IOException e) {
            throw new PluginException("Unable to processing CSV", e);
        }
    }

    private CsvSchema.Builder getBuilder(MediaType mediaType) {
        CsvSchema.Builder builder = CsvSchema.builder();
        String useHeadrStr = mediaType.getParameter(DS_PARAM_USE_HEADER);
        boolean useHeader = Boolean.parseBoolean(Optional.ofNullable(useHeadrStr).orElse("true"));
        builder.setUseHeader(useHeader);
        String disableQuotesStr = mediaType.getParameter(DS_PARAM_DISABLE_QUOTES);
        boolean disableQuotes = Boolean.parseBoolean(Optional.ofNullable(disableQuotesStr).orElse("false"));
        if (disableQuotes) {
            builder.disableQuoteChar();
        } else if (mediaType.getParameter(DS_PARAM_QUOTE_CHAR) != null) {
            builder.setQuoteChar(mediaType.getParameter(DS_PARAM_QUOTE_CHAR).charAt(0));
        }
        if (mediaType.getParameter(DS_PARAM_SEPARATOR_CHAR) != null) {
            builder.setColumnSeparator(mediaType.getParameter(DS_PARAM_SEPARATOR_CHAR).charAt(0));
        }
        if (mediaType.getParameter(DS_PARAM_ESCAPE_CHAR) != null) {
            builder.setEscapeChar(mediaType.getParameter(DS_PARAM_ESCAPE_CHAR).charAt(0));
        }
        if (mediaType.getParameter(DS_PARAM_NEW_LINE) != null) {
            builder.setLineSeparator(mediaType.getParameter(DS_PARAM_NEW_LINE).replaceAll("LF", "\n").replaceAll("CR", "\r"));
        }
        return builder;
    }

    static {
        CSV_MAPPER.enable(CsvParser.Feature.WRAP_AS_ARRAY);
    }
}

