/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner;

import com.datasqrl.flinkrunner.EnvVarResolver;
import com.datasqrl.flinkrunner.SqlExecutor;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseRunner.class);
    final RuntimeExecutionMode mode;
    final EnvVarResolver resolver;
    @Nullable
    final String sqlFile;
    @Nullable
    final String planFile;
    @Nullable
    final String configDir;
    @Nullable
    final String udfPath;
    @Nullable
    final Configuration config;

    public TableResult run() throws Exception {
        Configuration execConfig = this.config != null ? this.config : this.initConfiguration();
        return this.run(() -> new SqlExecutor(execConfig, this.udfPath));
    }

    @VisibleForTesting
    TableResult run(Supplier<SqlExecutor> sqlExecutorSupplier) throws Exception {
        SqlExecutor sqlExecutor = sqlExecutorSupplier.get();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.sqlFile, this.planFile})) {
            throw new IllegalArgumentException("Provide either a SQL file or a compiled plan - not both.");
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.sqlFile, this.planFile})) {
            throw new IllegalArgumentException("Invalid input. Please provide one of the following combinations: 1. A single SQL file (--sqlfile) 2. A plan JSON file (--planfile)");
        }
        if (StringUtils.isNotBlank((CharSequence)this.sqlFile)) {
            String script = BaseRunner.readTextFile(this.sqlFile);
            script = this.resolver.resolve(script);
            sqlExecutor.setupSystemFunctions();
            return sqlExecutor.executeScript(script);
        }
        String planJson = BaseRunner.readTextFile(this.planFile);
        planJson = this.resolver.resolveInJson(planJson);
        sqlExecutor.setupSystemFunctions();
        return sqlExecutor.executeCompiledPlan(planJson);
    }

    @VisibleForTesting
    Configuration initConfiguration() {
        Configuration conf = new Configuration();
        if (StringUtils.isNotBlank((CharSequence)this.configDir)) {
            log.info("Loading Flink configuration from '{}'", (Object)this.configDir);
            conf = GlobalConfiguration.loadConfiguration((String)this.configDir);
        }
        if (!conf.contains(ExecutionOptions.RUNTIME_MODE)) {
            conf.set(ExecutionOptions.RUNTIME_MODE, (Object)this.mode);
        }
        return conf;
    }

    static String readTextFile(String path) throws IOException {
        File f = new File(path);
        if (!f.exists()) {
            throw new IllegalArgumentException(String.format("Given file '%s' does not exist", path));
        }
        if (!f.isFile()) {
            throw new IllegalArgumentException(String.format("Given file '%s' is not a regular file", path));
        }
        return FileUtils.readFileUtf8((File)f);
    }

    @Generated
    public BaseRunner(RuntimeExecutionMode mode, EnvVarResolver resolver, @Nullable String sqlFile, @Nullable String planFile, @Nullable String configDir, @Nullable String udfPath, @Nullable Configuration config) {
        this.mode = mode;
        this.resolver = resolver;
        this.sqlFile = sqlFile;
        this.planFile = planFile;
        this.configDir = configDir;
        this.udfPath = udfPath;
        this.config = config;
    }
}

