/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner;

import com.datasqrl.flinkrunner.BaseRunner;
import com.datasqrl.flinkrunner.EnvVarResolver;
import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class CliRunner
extends BaseRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CliRunner.class);

    public CliRunner(RuntimeExecutionMode mode, @Nullable String sqlFile, @Nullable String planFile, @Nullable String configDir, @Nullable String udfPath) {
        this(mode, new EnvVarResolver(), sqlFile, planFile, configDir, udfPath);
    }

    @VisibleForTesting
    CliRunner(RuntimeExecutionMode mode, EnvVarResolver resolver, @Nullable String sqlFile, @Nullable String planFile, @Nullable String configDir, @Nullable String udfPath) {
        super(mode, resolver, sqlFile, planFile, configDir, udfPath, null);
    }

    public static void main(String[] args) throws Exception {
        log.info("Executing flink-sql-runner: {}", (Object)Arrays.toString(args));
        CommandLine cl = new CommandLine((Object)new SqlRunner());
        int resCode = cl.execute(args);
        if (resCode != 0) {
            System.exit(resCode);
        }
        if (cl.isUsageHelpRequested()) {
            return;
        }
        SqlRunner runner = (SqlRunner)cl.getCommand();
        if (runner.udfPath == null) {
            runner.udfPath = System.getenv("UDF_PATH");
        }
        new CliRunner(runner.mode, runner.sqlFile, runner.planFile, runner.configDir, runner.udfPath).run();
        log.info("Finished flink-sql-runner execution");
    }

    @CommandLine.Command(name="SqlRunner", mixinStandardHelpOptions=true, version={"0.6"}, description={"Runs SQL scripts using Flink TableEnvironment."})
    public static class SqlRunner
    implements Callable<Void> {
        @CommandLine.Option(names={"-m", "--mode"}, defaultValue="STREAMING", description={"Flink runtime execution mode to apply to the given SQL program. Valid values: ${COMPLETION-CANDIDATES}."})
        private RuntimeExecutionMode mode;
        @CommandLine.Option(names={"-s", "--sqlfile"}, description={"SQL file to execute."})
        private String sqlFile;
        @CommandLine.Option(names={"-p", "--planfile"}, description={"Compiled plan JSON file."})
        private String planFile;
        @CommandLine.Option(names={"-c", "--config-dir"}, description={"Directory containing configuration YAML file."})
        private String configDir;
        @CommandLine.Option(names={"-u", "--udfpath"}, description={"Path to UDFs."})
        private String udfPath;

        @Override
        public Void call() {
            return null;
        }
    }
}

