/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvVarResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvVarResolver.class);
    private static final Pattern ENVIRONMENT_VARIABLE_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    private final Map<String, String> envVars;
    private final ObjectMapper objectMapper;

    public EnvVarResolver() {
        this(System.getenv());
    }

    public EnvVarResolver(Map<String, String> envVars) {
        this.envVars = envVars;
        this.objectMapper = this.initObjectMapper();
    }

    public String resolve(String src) {
        if (StringUtils.isBlank((CharSequence)src)) {
            return src;
        }
        StringBuffer res = new StringBuffer();
        Matcher matcher = ENVIRONMENT_VARIABLE_PATTERN.matcher(src);
        HashSet<String> missingEnvVars = new HashSet<String>();
        while (matcher.find()) {
            String key;
            String rawKey = matcher.group(1);
            String defaultValue = null;
            int colonIdx = rawKey.indexOf(58);
            if (colonIdx >= 0) {
                key = rawKey.substring(0, colonIdx);
                defaultValue = rawKey.substring(colonIdx + 1);
            } else {
                key = rawKey;
            }
            if (this.envVars.containsKey(key)) {
                String envValue = this.envVars.get(key);
                matcher.appendReplacement(res, Matcher.quoteReplacement(envValue));
                continue;
            }
            if (defaultValue != null) {
                matcher.appendReplacement(res, Matcher.quoteReplacement(defaultValue));
                continue;
            }
            missingEnvVars.add(key);
        }
        matcher.appendTail(res);
        if (!missingEnvVars.isEmpty()) {
            throw new IllegalStateException(String.format("The following environment variables were referenced, but not found: %s", missingEnvVars));
        }
        return res.toString();
    }

    public String resolveInJson(String jsonSrc) throws IOException {
        Map res = (Map)this.objectMapper.readValue(jsonSrc, Map.class);
        return this.objectMapper.writeValueAsString((Object)res);
    }

    private ObjectMapper initObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String.class, (JsonDeserializer)new JsonEnvVarDeserializer());
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    private class JsonEnvVarDeserializer
    extends JsonDeserializer<String> {
        private JsonEnvVarDeserializer() {
        }

        public String deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            String value = parser.getText();
            return EnvVarResolver.this.resolve(value);
        }
    }
}

